/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import com.intellij.openapi.roots.ui.util.ModifiableCellAppearance;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class CompositeAppearance
implements ModifiableCellAppearance {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.util.CompositeAppearance");
    private Icon myIcon;
    private final ArrayList<TextSection> mySections = new ArrayList();
    private int myInsertionIndex = 0;

    @Override
    public synchronized void customize(SimpleColoredComponent component) {
        for (TextSection section : this.mySections) {
            TextAttributes attributes = section.ATTRIBUTES;
            component.append(section.TEXT, SimpleTextAttributes.fromTextAttributes(attributes));
        }
        component.setIcon(this.myIcon);
    }

    @Override
    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    @Override
    public synchronized String getText() {
        StringBuilder buffer = new StringBuilder();
        for (TextSection section : this.mySections) {
            buffer.append(section.TEXT);
        }
        return buffer.toString();
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof CompositeAppearance)) {
            return false;
        }
        CompositeAppearance appearance = (CompositeAppearance)obj;
        if (SwingUtilities.isEventDispatchThread()) {
            return appearance.mySections.equals(this.mySections);
        }
        return new ArrayList<TextSection>(appearance.mySections).equals(new ArrayList<TextSection>(this.mySections));
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSectionAt(int index, @NotNull TextSection section) {
        if (section == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/util/CompositeAppearance.addSectionAt must not be null");
        }
        CompositeAppearance compositeAppearance = this;
        synchronized (compositeAppearance) {
            this.mySections.add(index, section);
            Iterator<TextSection> iterator = this.mySections.iterator();
            while (iterator.hasNext()) {
                TextSection textSection = iterator.next();
                if (textSection != null) continue;
                LOG.error("index: " + index + " size: " + this.mySections.size());
                iterator.remove();
            }
        }
    }

    public DequeEnd getBeginning() {
        return new DequeBeginning();
    }

    public DequeEnd getEnding() {
        return new DequeEnding();
    }

    public DequeEnd getSuffix() {
        return new DequeSuffix();
    }

    public static CompositeAppearance textComment(String text, String comment) {
        DequeEnd ending = new CompositeAppearance().getEnding();
        ending.addText(text);
        ending.addComment(comment);
        return ending.getAppearance();
    }

    public static CompositeAppearance single(String text, SimpleTextAttributes textAttributes) {
        CompositeAppearance result = new CompositeAppearance();
        result.getEnding().addText(text, textAttributes);
        return result;
    }

    public static CompositeAppearance single(String text) {
        return CompositeAppearance.single(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public static CompositeAppearance invalid(String absolutePath) {
        CompositeAppearance appearance = new CompositeAppearance();
        appearance.setIcon(CellAppearanceUtils.INVALID_ICON);
        appearance.getEnding().addText(absolutePath, SimpleTextAttributes.ERROR_ATTRIBUTES);
        return appearance;
    }

    public Iterator<TextSection> getSectionsIterator() {
        return this.mySections.iterator();
    }

    private class DequeSuffix
    extends DequeEnd {
        private DequeSuffix() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSection(TextSection section) {
            CompositeAppearance compositeAppearance = CompositeAppearance.this;
            synchronized (compositeAppearance) {
                CompositeAppearance.this.addSectionAt(CompositeAppearance.this.mySections.size(), section);
            }
        }
    }

    private class DequeEnding
    extends DequeEnd {
        private DequeEnding() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSection(TextSection section) {
            CompositeAppearance compositeAppearance = CompositeAppearance.this;
            synchronized (compositeAppearance) {
                CompositeAppearance.this.addSectionAt(CompositeAppearance.this.myInsertionIndex, section);
                CompositeAppearance.this.myInsertionIndex++;
            }
        }
    }

    private class DequeBeginning
    extends DequeEnd {
        private DequeBeginning() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSection(TextSection section) {
            CompositeAppearance compositeAppearance = CompositeAppearance.this;
            synchronized (compositeAppearance) {
                CompositeAppearance.this.addSectionAt(0, section);
                CompositeAppearance.this.myInsertionIndex++;
            }
        }
    }

    public abstract class DequeEnd {
        public void addText(String text, SimpleTextAttributes textAttributes) {
            this.addText(text, textAttributes.toTextAttributes());
        }

        public void addText(String text) {
            this.addText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        public abstract void addSection(TextSection var1);

        public void addText(String text, TextAttributes attributes) {
            this.addSection(new TextSection(text, attributes));
        }

        public void addSurrounded(String text, String prefix, String suffix, SimpleTextAttributes textAttributes) {
            if (text != null && text.trim().length() > 0) {
                this.addText(prefix + text + suffix, textAttributes);
            }
        }

        public CompositeAppearance getAppearance() {
            return CompositeAppearance.this;
        }

        public void addComment(String comment, SimpleTextAttributes commentAttributes) {
            this.addSurrounded(comment, " (", ")", commentAttributes);
        }

        public void addComment(String comment) {
            this.addComment(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    protected static class TextSection {
        private static final TextAttributes DEFAULT_TEXT_ATTRIBUTES = new TextAttributes(null, null, null, null, 0);
        private static final String DEFAULT_TEXT = "";
        public String TEXT;
        public TextAttributes ATTRIBUTES;

        public TextSection(String text, TextAttributes attributes) {
            this.ATTRIBUTES = attributes == null ? DEFAULT_TEXT_ATTRIBUTES : attributes;
            this.TEXT = text == null ? DEFAULT_TEXT : text;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TextSection)) {
                return false;
            }
            TextSection section = (TextSection)obj;
            return section.ATTRIBUTES.equals(this.ATTRIBUTES) && section.TEXT.equals(this.TEXT);
        }

        public int hashCode() {
            return this.TEXT.hashCode();
        }
    }
}

