/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public abstract class ModuleType<T extends ModuleBuilder> {
    public static ModuleType EMPTY = ModuleType.instantiate("com.intellij.openapi.module.EmptyModuleType");
    private final String myId;

    protected ModuleType(@NonNls String id) {
        this.myId = id;
    }

    public abstract T createModuleBuilder();

    public abstract String getName();

    public abstract String getDescription();

    public abstract Icon getBigIcon();

    public abstract Icon getNodeIcon(boolean var1);

    public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, T moduleBuilder, ModulesProvider modulesProvider) {
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    public final String getId() {
        return this.myId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleType)) {
            return false;
        }
        ModuleType moduleType = (ModuleType)o;
        return !(this.myId != null ? !this.myId.equals(moduleType.myId) : moduleType.myId != null);
    }

    public final int hashCode() {
        return this.myId != null ? this.myId.hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }

    private static ModuleType instantiate(String className) {
        try {
            return (ModuleType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isValidSdk(Module module, Sdk projectSdk) {
        return true;
    }
}

