/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.Color;
import org.jdom.Element;

public class TextAttributes
implements JDOMExternalizable,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.markup.TextAttributes");
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    private AttributesFlyweight myAttrs;

    public static TextAttributes merge(TextAttributes under, TextAttributes above) {
        if (under == null) {
            return above;
        }
        if (above == null) {
            return under;
        }
        TextAttributes attrs = under.clone();
        if (above.getBackgroundColor() != null) {
            attrs.setBackgroundColor(above.getBackgroundColor());
        }
        if (above.getForegroundColor() != null) {
            attrs.setForegroundColor(above.getForegroundColor());
        }
        attrs.setFontType(above.getFontType() | under.getFontType());
        if (above.getEffectColor() != null) {
            attrs.setEffectColor(above.getEffectColor());
            attrs.setEffectType(above.getEffectType());
        }
        return attrs;
    }

    public TextAttributes() {
        this.myAttrs = AttributesFlyweight.create(null, null, 0, null, EffectType.BOXED, null);
    }

    public TextAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, EffectType effectType, int fontType) {
        this.myAttrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, null);
    }

    public boolean isEmpty() {
        return this.getForegroundColor() == null && this.getBackgroundColor() == null && this.getEffectColor() == null && this.getFontType() == 0;
    }

    public AttributesFlyweight getFlyweight() {
        return this.myAttrs;
    }

    public static TextAttributes fromFlyweight(AttributesFlyweight flyweight) {
        TextAttributes f = new TextAttributes();
        f.myAttrs = flyweight;
        return f;
    }

    public Color getForegroundColor() {
        return this.myAttrs.getForeground();
    }

    public void setForegroundColor(Color color) {
        this.myAttrs = this.myAttrs.withForeground(color);
    }

    public Color getBackgroundColor() {
        return this.myAttrs.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.myAttrs = this.myAttrs.withBackground(color);
    }

    public Color getEffectColor() {
        return this.myAttrs.getEffectColor();
    }

    public void setEffectColor(Color color) {
        this.myAttrs = this.myAttrs.withEffectColor(color);
    }

    public Color getErrorStripeColor() {
        return this.myAttrs.getErrorStripeColor();
    }

    public void setErrorStripeColor(Color color) {
        this.myAttrs = this.myAttrs.withErrorStripeColor(color);
    }

    public EffectType getEffectType() {
        return this.myAttrs.getEffectType();
    }

    public void setEffectType(EffectType effectType) {
        this.myAttrs = this.myAttrs.withEffectType(effectType);
    }

    public int getFontType() {
        return this.myAttrs.getFontType();
    }

    public void setFontType(int type) {
        if (type < 0 || type > 3) {
            LOG.error("Wrong font type: " + type);
            type = 0;
        }
        this.myAttrs = this.myAttrs.withFontType(type);
    }

    public TextAttributes clone() {
        TextAttributes cloned = new TextAttributes();
        cloned.myAttrs = this.myAttrs;
        return cloned;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        TextAttributes textAttributes = (TextAttributes)obj;
        if (!Comparing.equal((Object)textAttributes.getForegroundColor(), (Object)this.getForegroundColor())) {
            return false;
        }
        if (!Comparing.equal((Object)textAttributes.getBackgroundColor(), (Object)this.getBackgroundColor())) {
            return false;
        }
        if (!Comparing.equal((Object)textAttributes.getErrorStripeColor(), (Object)this.getErrorStripeColor())) {
            return false;
        }
        if (!Comparing.equal((Object)textAttributes.getEffectColor(), (Object)this.getEffectColor())) {
            return false;
        }
        if (textAttributes.getEffectType() != this.getEffectType()) {
            return false;
        }
        return textAttributes.getFontType() == this.getFontType();
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getForegroundColor() != null) {
            hashCode += this.getForegroundColor().hashCode();
        }
        if (this.getBackgroundColor() != null) {
            hashCode += this.getBackgroundColor().hashCode();
        }
        if (this.getErrorStripeColor() != null) {
            hashCode += this.getErrorStripeColor().hashCode();
        }
        if (this.getEffectColor() != null) {
            hashCode += this.getEffectColor().hashCode();
        }
        return hashCode += this.getFontType();
    }

    public void readExternal(Element element) throws InvalidDataException {
        Externalizable ext = new Externalizable();
        ext.readExternal(element);
        this.myAttrs = AttributesFlyweight.create(ext.FOREGROUND, ext.BACKGROUND, ext.FONT_TYPE, ext.EFFECT_COLOR, ext.getEffectType(), ext.ERROR_STRIPE_COLOR);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Externalizable ext = new Externalizable();
        ext.FOREGROUND = this.myAttrs.getForeground();
        ext.BACKGROUND = this.myAttrs.getBackground();
        ext.FONT_TYPE = this.myAttrs.getFontType();
        ext.EFFECT_COLOR = this.myAttrs.getEffectColor();
        ext.ERROR_STRIPE_COLOR = this.myAttrs.getErrorStripeColor();
        ext.setEffectType(this.myAttrs.getEffectType());
        ext.writeExternal(element);
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.getErrorStripeColor() + "]";
    }

    private static class Externalizable
    implements Cloneable,
    JDOMExternalizable {
        public Color FOREGROUND = null;
        public Color BACKGROUND = null;
        public int FONT_TYPE = 0;
        public Color EFFECT_COLOR = null;
        public int EFFECT_TYPE = 0;
        public Color ERROR_STRIPE_COLOR = null;
        private static final int EFFECT_BORDER = 0;
        private static final int EFFECT_LINE = 1;
        private static final int EFFECT_WAVE = 2;
        private static final int EFFECT_STRIKEOUT = 3;
        private static final int EFFECT_BOLD_LINE = 4;

        private Externalizable() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
            if (this.FONT_TYPE < 0 || this.FONT_TYPE > 3) {
                LOG.info("Wrong font type: " + this.FONT_TYPE);
                this.FONT_TYPE = 0;
            }
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }

        private EffectType getEffectType() {
            switch (this.EFFECT_TYPE) {
                case 0: {
                    return EffectType.BOXED;
                }
                case 4: {
                    return EffectType.BOLD_LINE_UNDERSCORE;
                }
                case 1: {
                    return EffectType.LINE_UNDERSCORE;
                }
                case 3: {
                    return EffectType.STRIKEOUT;
                }
                case 2: {
                    return EffectType.WAVE_UNDERSCORE;
                }
            }
            return null;
        }

        private void setEffectType(EffectType effectType) {
            this.EFFECT_TYPE = effectType == EffectType.BOXED ? 0 : (effectType == EffectType.LINE_UNDERSCORE ? 1 : (effectType == EffectType.BOLD_LINE_UNDERSCORE ? 4 : (effectType == EffectType.STRIKEOUT ? 3 : (effectType == EffectType.WAVE_UNDERSCORE ? 2 : -1))));
        }
    }
}

