/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CompositeDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    private final List<DocumentationProvider> myProviders;

    public CompositeDocumentationProvider(DocumentationProvider ... documentationProviders) {
        this(Arrays.asList(documentationProviders));
    }

    public CompositeDocumentationProvider(Collection<DocumentationProvider> providers) {
        this.myProviders = new ArrayList<DocumentationProvider>(providers);
    }

    public void inject(DocumentationProvider provider) {
        this.myProviders.add(provider);
    }

    public void remove(DocumentationProvider provider) {
        this.myProviders.remove(provider);
    }

    public List<DocumentationProvider> getProviders() {
        return Collections.unmodifiableList(this.myProviders);
    }

    @Override
    public String getQuickNavigateInfo(PsiElement element) {
        for (DocumentationProvider provider : this.myProviders) {
            String result = provider.getQuickNavigateInfo(element);
            if (result == null) continue;
            return result;
        }
        for (DocumentationProvider provider : (DocumentationProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            String result = provider.getQuickNavigateInfo(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.myProviders) {
            List<String> result = provider.getUrlFor(element, originalElement);
            if (result == null) continue;
            return result;
        }
        for (DocumentationProvider provider : (DocumentationProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            List<String> result = provider.getUrlFor(element, originalElement);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.myProviders) {
            String result = provider.generateDoc(element, originalElement);
            if (result == null) continue;
            return result;
        }
        for (DocumentationProvider provider : (DocumentationProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            String result = provider.generateDoc(element, originalElement);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        for (DocumentationProvider provider : this.myProviders) {
            PsiElement result = provider.getDocumentationElementForLookupItem(psiManager, object, element);
            if (result == null) continue;
            return result;
        }
        for (DocumentationProvider provider : (DocumentationProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            PsiElement result = provider.getDocumentationElementForLookupItem(psiManager, object, element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        for (DocumentationProvider provider : this.myProviders) {
            PsiElement result = provider.getDocumentationElementForLink(psiManager, link, context);
            if (result == null) continue;
            return result;
        }
        for (DocumentationProvider provider : (DocumentationProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            PsiElement result = provider.getDocumentationElementForLink(psiManager, link, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public CodeDocumentationProvider getFirstCodeDocumentationProvider() {
        for (DocumentationProvider provider : this.myProviders) {
            if (!(provider instanceof CodeDocumentationProvider)) continue;
            return (CodeDocumentationProvider)provider;
        }
        return null;
    }

    @Override
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        for (DocumentationProvider provider : this.myProviders) {
            String doc;
            if (!(provider instanceof ExternalDocumentationProvider) || (doc = ((ExternalDocumentationProvider)((Object)provider)).fetchExternalDocumentation(project, element, docUrls)) == null) continue;
            return doc;
        }
        return null;
    }
}

