/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class NodeRenderer
extends ColoredTreeCellRenderer {
    @Override
    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object node;
        Object userObject;
        Color color = null;
        NodeDescriptor descriptor = null;
        if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)(node = (DefaultMutableTreeNode)value)).getUserObject()) instanceof NodeDescriptor) {
            descriptor = (NodeDescriptor)userObject;
            color = descriptor.getColor();
            if (expanded) {
                this.setIcon(descriptor.getOpenIcon());
            } else {
                this.setIcon(descriptor.getClosedIcon());
            }
        }
        if (descriptor instanceof PresentableNodeDescriptor) {
            node = (PresentableNodeDescriptor)descriptor;
            PresentationData presentation = ((PresentableNodeDescriptor)node).getPresentation();
            List<PresentableNodeDescriptor.ColoredFragment> coloredText = presentation.getColoredText();
            if (coloredText.size() == 0) {
                String text = tree.convertValueToText(value.toString(), selected, expanded, leaf, row, hasFocus);
                SimpleTextAttributes simpleTextAttributes = NodeRenderer.getSimpleTextAttributes((PresentableNodeDescriptor)node, presentation.getForcedTextForeground() != null ? presentation.getForcedTextForeground() : color);
                this.append(text, simpleTextAttributes);
            } else {
                for (PresentableNodeDescriptor.ColoredFragment each : coloredText) {
                    this.append(each.getText(), each.getAttributes(), true);
                }
            }
            String location = presentation.getLocationString();
            if (location != null && location.length() > 0) {
                this.append(" (" + location + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            this.setToolTipText(presentation.getTooltip());
        } else if (value != null) {
            String text = value.toString();
            if (descriptor != null) {
                text = descriptor.myName;
            }
            if ((text = tree.convertValueToText(text, selected, expanded, leaf, row, hasFocus)) == null) {
                text = "";
            }
            this.append(text);
            this.setToolTipText(null);
        }
    }

    protected static SimpleTextAttributes getSimpleTextAttributes(PresentableNodeDescriptor node, Color color) {
        SimpleTextAttributes simpleTextAttributes = NodeRenderer.getSimpleTextAttributes(node.getPresentation());
        if (color != null) {
            TextAttributes textAttributes = simpleTextAttributes.toTextAttributes();
            textAttributes.setForegroundColor(color);
            simpleTextAttributes = SimpleTextAttributes.fromTextAttributes(textAttributes);
        }
        return simpleTextAttributes;
    }

    public static SimpleTextAttributes getSimpleTextAttributes(ItemPresentation presentation) {
        TextAttributesKey textAttributesKey = presentation.getTextAttributesKey();
        if (textAttributesKey == null) {
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(textAttributesKey);
        return textAttributes == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.fromTextAttributes(textAttributes);
    }
}

