/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Icons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeCanonicalLookupElement
extends LookupElement {
    private static final Icon EMPTY_ICON = new EmptyIcon(Icons.CLASS_ICON.getIconWidth() * 2, Icons.CLASS_ICON.getIconHeight());
    private final PsiType myType;
    private final String myPresentableText;

    public PsiTypeCanonicalLookupElement(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement.<init> must not be null");
        }
        this.myType = type;
        this.myPresentableText = this.myType.getPresentableText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Object getObject() {
        Object object;
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            object = psiClass;
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement.getObject must not return null");
            return object;
        }
        object = super.getObject();
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement.getObject must not return null");
    }

    @Nullable
    public PsiClass getPsiClass() {
        return PsiUtil.resolveClassInType(this.myType);
    }

    public PsiType getPsiType() {
        return this.myType;
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myPresentableText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/util/PsiTypeCanonicalLookupElement.getLookupString must not return null");
        }
        return string;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        context.getEditor().getDocument().replaceString(context.getStartOffset(), context.getStartOffset() + this.getLookupString().length(), this.getPsiType().getCanonicalText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiTypeCanonicalLookupElement)) {
            return false;
        }
        PsiTypeCanonicalLookupElement that = (PsiTypeCanonicalLookupElement)((Object)o);
        return this.myType.equals(that.myType);
    }

    public int hashCode() {
        return this.myType.hashCode();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            presentation.setIcon(presentation.isReal() ? psiClass.getIcon(1) : EMPTY_ICON);
            presentation.setTailText(" (" + PsiFormatUtil.getPackageDisplayName(psiClass) + ")", true);
        }
        PsiType type = this.getPsiType();
        presentation.setItemText(type.getPresentableText());
        presentation.setItemTextBold(type instanceof PsiPrimitiveType);
    }
}

