/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class CompletionResultSet {
    private final PrefixMatcher myPrefixMatcher;
    private final Consumer<LookupElement> myConsumer;
    private final CompletionService myCompletionService = CompletionService.getCompletionService();
    protected final CompletionContributor myContributor;
    private boolean myStopped;

    protected CompletionResultSet(PrefixMatcher prefixMatcher, Consumer<LookupElement> consumer, CompletionContributor contributor) {
        this.myPrefixMatcher = prefixMatcher;
        this.myConsumer = consumer;
        this.myContributor = contributor;
    }

    protected Consumer<LookupElement> getConsumer() {
        return this.myConsumer;
    }

    public void addElement(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionResultSet.addElement must not be null");
        }
        if (this.myCompletionService.prefixMatches(element, this.getPrefixMatcher())) {
            this.myConsumer.consume((Object)element);
        }
    }

    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher var1);

    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull String var1);

    @NotNull
    public abstract CompletionResultSet caseInsensitive();

    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myPrefixMatcher;
        if (prefixMatcher == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionResultSet.getPrefixMatcher must not return null");
        }
        return prefixMatcher;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public void stopHere() {
        this.myStopped = true;
    }

    public void runRemainingContributors(CompletionParameters parameters, Consumer<LookupElement> consumer) {
        this.runRemainingContributors(parameters, consumer, true);
    }

    public void runRemainingContributors(CompletionParameters parameters, Consumer<LookupElement> consumer, boolean stop) {
        if (stop) {
            this.stopHere();
        }
        this.myCompletionService.getVariantsFromContributors(parameters, this.myContributor, consumer);
    }
}

