/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class CodeSmellInfo {
    @NotNull
    private final Document myDocument;
    private final String myDescription;
    private final TextRange myTextRange;
    private final HighlightSeverity mySeverity;

    public CodeSmellInfo(@NotNull Document document, String description, TextRange textRange, HighlightSeverity severity) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/CodeSmellInfo.<init> must not be null");
        }
        this.myDocument = document;
        this.myDescription = description;
        this.myTextRange = textRange;
        this.mySeverity = severity;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/CodeSmellInfo.getDocument must not return null");
        }
        return document;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public TextRange getTextRange() {
        return this.myTextRange;
    }

    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public int getStartLine() {
        return this.getDocument().getLineNumber(this.getTextRange().getStartOffset());
    }

    public int getStartColumn() {
        return this.getTextRange().getStartOffset() - this.getDocument().getLineStartOffset(this.getStartLine());
    }
}

