/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.inspections.SplitterFactory;
import com.intellij.spellchecker.inspections.TextSplitter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextSplitter
extends BaseSplitter {
    @NonNls
    private static final Pattern COMPLEX = Pattern.compile("([\\p{L}0-9\\.\\-\\_]+@([\\p{L}0-9\\-\\_]+\\.)+(com|net|[a-z]{2}))|((ftp|http|file|https)://([^/]+)(/.*)?(/.*))");

    @Override
    public List<CheckArea> split(@Nullable String text, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/PlainTextSplitter.split must not be null");
        }
        if (text == null || StringUtil.isEmpty((String)text)) {
            return null;
        }
        if (Verifier.checkCharacterData((String)text.substring(range.getStartOffset(), range.getEndOffset())) != null) {
            return null;
        }
        List<TextRange> toCheck = PlainTextSplitter.excludeByPattern(text, range, COMPLEX, 0);
        if (toCheck == null) {
            return null;
        }
        ArrayList<CheckArea> results = new ArrayList<CheckArea>();
        TextSplitter ws = SplitterFactory.getInstance().getTextSplitterNew();
        for (TextRange r : toCheck) {
            PlainTextSplitter.checkCancelled();
            List<CheckArea> res = ws.split(text, r);
            if (res == null) continue;
            results.addAll(res);
        }
        return results.size() == 0 ? null : results;
    }
}

