/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggregatedDictionary
implements EditableDictionary {
    private static final String DICTIONARY_NAME = "common";
    private EditableDictionary cachedDictionary;
    private ProjectDictionary projectDictionary;

    @Override
    public String getName() {
        return DICTIONARY_NAME;
    }

    public AggregatedDictionary(@NotNull ProjectDictionary projectDictionary, @NotNull EditableDictionary cachedDictionary) {
        if (projectDictionary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/dictionary/AggregatedDictionary.<init> must not be null");
        }
        if (cachedDictionary == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/dictionary/AggregatedDictionary.<init> must not be null");
        }
        this.projectDictionary = projectDictionary;
        this.cachedDictionary = cachedDictionary;
        this.cachedDictionary.addToDictionary(projectDictionary.getWords());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(String word) {
        if (word == null) {
            return false;
        }
        return this.cachedDictionary.contains(word);
    }

    @Override
    public void addToDictionary(String word) {
        this.getProjectDictionary().addToDictionary(word);
        this.getCachedDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getProjectDictionary().removeFromDictionary(word);
        this.getCachedDictionary().removeFromDictionary(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        Set<String> oldWords = this.getProjectDictionary().getWords();
        this.getProjectDictionary().replaceAll(words);
        if (oldWords != null) {
            for (String word : oldWords) {
                if (words != null && words.contains(word)) continue;
                this.getCachedDictionary().removeFromDictionary(word);
            }
        }
    }

    @Override
    public void clear() {
        this.getProjectDictionary().clear();
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/dictionary/AggregatedDictionary.traverse must not be null");
        }
        this.cachedDictionary.traverse(consumer);
    }

    @Override
    public Set<String> getWords() {
        return this.cachedDictionary != null ? this.cachedDictionary.getWords() : null;
    }

    @Override
    public int size() {
        return this.cachedDictionary != null ? this.cachedDictionary.size() : 0;
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.getProjectDictionary().getEditableWords();
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getProjectDictionary().addToDictionary(words);
        this.getCachedDictionary().addToDictionary(words);
    }

    public EditableDictionary getCachedDictionary() {
        return this.cachedDictionary;
    }

    public ProjectDictionary getProjectDictionary() {
        return this.projectDictionary;
    }
}

