/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.util.Consumer;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class UnitBitSet
extends BitSet {
    public int bitsPerUnit = 10;

    public UnitBitSet() {
    }

    public UnitBitSet(int value, boolean exact) {
        if (exact) {
            this.bitsPerUnit = value;
        } else {
            while (value != 0) {
                ++this.bitsPerUnit;
                value >>= 1;
            }
        }
    }

    public void inc() {
        boolean t = true;
        for (int i = 0; i <= this.size(); ++i) {
            if (!this.get(i) && t) {
                this.set(i);
                t = false;
                continue;
            }
            if (!this.get(i) || !t) continue;
            this.set(i, false);
        }
    }

    public int getUnitValue(int number) {
        int startIndex = number * this.bitsPerUnit;
        int result = 0;
        for (int i = 0; i < this.bitsPerUnit; ++i) {
            if (!this.get(startIndex + i)) continue;
            result += 1 << i;
        }
        return result;
    }

    public void setUnitValue(int number, int value) {
        if (value > (1 << this.bitsPerUnit) - 1) {
            throw new IllegalArgumentException();
        }
        int startIndex = number * this.bitsPerUnit;
        for (int i = 0; i < this.bitsPerUnit; ++i) {
            this.set(startIndex + i, value % 2 == 1);
            value /= 2;
        }
    }

    public void setBits(int ... bits) {
        if (bits == null) {
            return;
        }
        for (int bit : bits) {
            this.set(bit);
        }
    }

    public void moveLeft(int n) {
        int i;
        if (n <= 0) {
            return;
        }
        for (i = 0; i < this.size() - n * this.bitsPerUnit; ++i) {
            this.set(i, this.get(n * this.bitsPerUnit + i));
        }
        for (i = this.size() - n * this.bitsPerUnit; i < this.size(); ++i) {
            this.set(i, false);
        }
    }

    public void moveRight(int n) {
        int i;
        if (n <= 0) {
            return;
        }
        for (i = this.size() - 1; i >= 0; --i) {
            this.set(i + n * this.bitsPerUnit, this.get(i));
        }
        for (i = 0; i < n * this.bitsPerUnit; ++i) {
            this.set(i, false);
        }
    }

    public void iterateParUnits(@NotNull Consumer<Integer> consumer, int offset, boolean skipLastZero) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/UnitBitSet.iterateParUnits must not be null");
        }
        int units = this.size() / this.bitsPerUnit;
        for (int i = offset; i <= units; ++i) {
            consumer.consume((Object)this.getUnitValue(i));
            if (skipLastZero && this.nextSetBit(i) == -1) break;
        }
    }

    public static UnitBitSet create(int ... bits) {
        UnitBitSet bs = new UnitBitSet();
        bs.setBits(bits);
        return bs;
    }

    public static UnitBitSet create(int bitsPerUnit, boolean exact, int ... bits) {
        UnitBitSet bs = new UnitBitSet(bitsPerUnit, exact);
        bs.setBits(bits);
        return bs;
    }

    public static UnitBitSet create(@NotNull BitSet bitSet, int bitsPerUnit) {
        if (bitSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/UnitBitSet.create must not be null");
        }
        UnitBitSet result = new UnitBitSet(bitsPerUnit, true);
        result.or(bitSet);
        return result;
    }
}

