/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ComboBoxPropertyEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ButtonGroupProperty
extends Property<RadComponent, RadButtonGroup> {
    private final LabelPropertyRenderer<RadButtonGroup> myRenderer = new LabelPropertyRenderer<RadButtonGroup>(){

        @Override
        protected void customize(@NotNull RadButtonGroup value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/propertyInspector/properties/ButtonGroupProperty$1.customize must not be null");
            }
            this.setText(value.getName());
        }
    };
    private final ComboBoxPropertyEditor<RadButtonGroup> myEditor = new MyPropertyEditor();

    public ButtonGroupProperty() {
        super(null, "Button Group");
    }

    @Override
    public RadButtonGroup getValue(RadComponent component) {
        RadRootContainer rootContainer = (RadRootContainer)FormEditingUtil.getRoot(component);
        return rootContainer == null ? null : (RadButtonGroup)FormEditingUtil.findGroupForComponent(rootContainer, component);
    }

    @Override
    protected void setValueImpl(RadComponent component, RadButtonGroup value) throws Exception {
        RadRootContainer radRootContainer = (RadRootContainer)FormEditingUtil.getRoot(component);
        assert (radRootContainer != null);
        radRootContainer.setGroupForComponent(component, value);
    }

    @Override
    @NotNull
    public PropertyRenderer<RadButtonGroup> getRenderer() {
        LabelPropertyRenderer<RadButtonGroup> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/ButtonGroupProperty.getRenderer must not return null");
        }
        return labelPropertyRenderer;
    }

    @Override
    public PropertyEditor<RadButtonGroup> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean isModified(RadComponent component) {
        return this.getValue(component) != null;
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        this.setValueImpl(component, null);
    }

    private static class MyPropertyEditor
    extends ComboBoxPropertyEditor<RadButtonGroup> {
        private RadRootContainer myRootContainer;
        private RadComponent myComponent;

        public MyPropertyEditor() {
            this.myCbx.setRenderer((ListCellRenderer)new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    RadButtonGroup group = (RadButtonGroup)value;
                    if (value == null) {
                        this.append(UIDesignerBundle.message("button.group.none", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (group == RadButtonGroup.NEW_GROUP) {
                        this.append(UIDesignerBundle.message("button.group.new", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(group.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
            this.myCbx.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && e.getItem() == RadButtonGroup.NEW_GROUP) {
                        String newGroupName = MyPropertyEditor.this.myRootContainer.suggestGroupName();
                        newGroupName = (String)JOptionPane.showInputDialog((Component)MyPropertyEditor.this.myCbx, UIDesignerBundle.message("button.group.name.prompt", new Object[0]), UIDesignerBundle.message("button.group.name.title", new Object[0]), 3, null, null, newGroupName);
                        if (newGroupName != null) {
                            RadButtonGroup group = MyPropertyEditor.this.myRootContainer.createGroup(newGroupName);
                            MyPropertyEditor.this.myRootContainer.setGroupForComponent(MyPropertyEditor.this.myComponent, group);
                            MyPropertyEditor.this.updateModel();
                        }
                    }
                }
            });
        }

        @Override
        public JComponent getComponent(RadComponent component, RadButtonGroup value, InplaceContext inplaceContext) {
            this.myComponent = component;
            this.myRootContainer = (RadRootContainer)FormEditingUtil.getRoot(this.myComponent);
            this.updateModel();
            return this.myCbx;
        }

        private void updateModel() {
            RadButtonGroup[] groups = this.myRootContainer.getButtonGroups();
            RadButtonGroup[] allGroups = new RadButtonGroup[groups.length + 2];
            System.arraycopy(groups, 0, allGroups, 1, groups.length);
            allGroups[allGroups.length - 1] = RadButtonGroup.NEW_GROUP;
            this.myCbx.setModel(new DefaultComboBoxModel<RadButtonGroup>(allGroups));
            this.myCbx.setSelectedItem((Object)FormEditingUtil.findGroupForComponent(this.myRootContainer, this.myComponent));
        }
    }
}

