/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntRegexEditor;
import com.intellij.uiDesigner.propertyInspector.properties.IntFieldProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.InsetsPropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Insets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInsetsProperty<T extends RadComponent>
extends Property<T, Insets> {
    private final Property[] myChildren = new Property[]{new IntFieldProperty(this, "top", 0, new Insets(0, 0, 0, 0)), new IntFieldProperty(this, "left", 0, new Insets(0, 0, 0, 0)), new IntFieldProperty(this, "bottom", 0, new Insets(0, 0, 0, 0)), new IntFieldProperty(this, "right", 0, new Insets(0, 0, 0, 0))};
    private final InsetsPropertyRenderer myRenderer = new InsetsPropertyRenderer();
    private IntRegexEditor<Insets> myEditor;

    public AbstractInsetsProperty(@NonNls String name) {
        this(null, name);
    }

    public AbstractInsetsProperty(Property parent, @NonNls String name) {
        super(parent, name);
    }

    @Override
    @NotNull
    public final Property[] getChildren(RadComponent component) {
        if (this.myChildren == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/AbstractInsetsProperty.getChildren must not return null");
        }
        return this.myChildren;
    }

    @Override
    @NotNull
    public final PropertyRenderer<Insets> getRenderer() {
        InsetsPropertyRenderer insetsPropertyRenderer = this.myRenderer;
        if (insetsPropertyRenderer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/AbstractInsetsProperty.getRenderer must not return null");
        }
        return insetsPropertyRenderer;
    }

    @Override
    public final PropertyEditor<Insets> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new IntRegexEditor<Insets>(Insets.class, (LabelPropertyRenderer)this.myRenderer, new int[]{0, 0, 0, 0}){

                @Override
                public Insets getValue() throws Exception {
                    try {
                        int value = Integer.parseInt(this.myTf.getText());
                        Insets insets = new Insets(value, value, value, value);
                        this.myTf.setText(AbstractInsetsProperty.this.myRenderer.formatText(insets));
                        return insets;
                    }
                    catch (NumberFormatException ex) {
                        return (Insets)super.getValue();
                    }
                }
            };
        }
        return this.myEditor;
    }
}

