/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItemProvider;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.palette.Palette;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NonNls;

public class UIDesignerPaletteProvider
implements PaletteItemProvider {
    private final Palette myPalette;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    @NonNls
    private static final String PROPERTY_GROUPS = "groups";

    public UIDesignerPaletteProvider(Palette palette) {
        this.myPalette = palette;
        this.myPalette.addListener(new Palette.Listener(){

            @Override
            public void groupsChanged(Palette palette) {
                UIDesignerPaletteProvider.this.fireGroupsChanged();
            }
        });
    }

    void fireGroupsChanged() {
        this.myPropertyChangeSupport.firePropertyChange(PROPERTY_GROUPS, null, null);
    }

    public PaletteGroup[] getActiveGroups(VirtualFile vFile) {
        if (vFile.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM)) {
            return this.myPalette.getToolWindowGroups();
        }
        return PaletteGroup.EMPTY_ARRAY;
    }

    public void addListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }
}

