/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.uiDesigner.binding.FormReferencesSearcher;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FormClassIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FormClassIndex");
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();
    private final MyInputFilter myInputFilter = new MyInputFilter();
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();

    public ID<String, Void> getName() {
        return NAME;
    }

    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myDataIndexer;
    }

    public KeyDescriptor<String> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    public static List<PsiFile> findFormsBoundToClass(Project project, String className) {
        return FormClassIndex.findFormsBoundToClass(project, className, ProjectScope.getAllScope((Project)project));
    }

    public static List<PsiFile> findFormsBoundToClass(final Project project, final String className, final GlobalSearchScope scope) {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<PsiFile>>(){

            public List<PsiFile> compute() {
                Collection files;
                try {
                    files = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)className, GlobalSearchScope.projectScope((Project)project).intersectWith(scope));
                }
                catch (IndexNotReadyException e) {
                    return Collections.emptyList();
                }
                if (files.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<PsiFile> result = new ArrayList<PsiFile>();
                for (VirtualFile file : files) {
                    PsiFile psiFile;
                    if (!file.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) continue;
                    result.add(psiFile);
                }
                return result;
            }
        });
    }

    public static List<PsiFile> findFormsBoundToClass(PsiClass psiClass) {
        String qName = FormReferencesSearcher.getQualifiedName(psiClass);
        if (qName == null) {
            return Collections.emptyList();
        }
        return FormClassIndex.findFormsBoundToClass(psiClass.getProject(), qName);
    }

    public static List<PsiFile> findFormsBoundToClass(PsiClass psiClass, GlobalSearchScope scope) {
        String qName = FormReferencesSearcher.getQualifiedName(psiClass);
        if (qName == null) {
            return Collections.emptyList();
        }
        return FormClassIndex.findFormsBoundToClass(psiClass.getProject(), qName, scope);
    }

    private static class MyInputFilter
    implements FileBasedIndex.InputFilter {
        private MyInputFilter() {
        }

        public boolean acceptInput(VirtualFile file) {
            return file.getFileType() == StdFileTypes.GUI_DESIGNER_FORM;
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public Map<String, Void> map(FileContent inputData) {
            Map<Object, Object> map;
            String className = null;
            try {
                className = Utils.getBoundClassName((String)((Object)inputData.getContentAsText()).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (className != null) {
                map = Collections.singletonMap(className, null);
                if (map == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/binding/FormClassIndex$MyDataIndexer.map must not return null");
                return map;
            }
            map = Collections.emptyMap();
            if (map != null) return map;
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/binding/FormClassIndex$MyDataIndexer.map must not return null");
        }
    }
}

