/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractCreateFormAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CreateFormAction
extends AbstractCreateFormAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.CreateFormAction");
    private String myLastClassName = null;
    private String myLastLayoutManager = null;

    public CreateFormAction() {
        super(UIDesignerBundle.message("action.gui.form.text", new Object[0]), UIDesignerBundle.message("action.gui.form.description", new Object[0]), Icons.UI_FORM_ICON);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                FileTemplateManager manager = FileTemplateManager.getInstance();
                FileTemplate template = manager.getTemplate("GUI Form");
                if (template != null && template.getExtension().equals("form")) {
                    manager.removeTemplate(template, false);
                }
            }
        });
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        MyDialog dialog = new MyDialog(project, validator);
        dialog.show();
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/actions/CreateFormAction.invokeDialog must not return null");
        }
        return psiElementArray;
    }

    protected void checkBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        if (this.myLastClassName != null) {
            JavaDirectoryService.getInstance().checkCreateClass(directory, this.myLastClassName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray;
        PsiElement createdFile;
        PsiClass newClass = null;
        try {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            assert (aPackage != null);
            String packageName = aPackage.getQualifiedName();
            String fqClassName = null;
            if (this.myLastClassName != null) {
                fqClassName = packageName.length() == 0 ? newName : packageName + "." + this.myLastClassName;
            }
            String formBody = this.createFormBody(fqClassName, "/com/intellij/uiDesigner/NewForm.xml", this.myLastLayoutManager);
            String fileName = newName + ".form";
            PsiFile formFile = PsiFileFactory.getInstance((Project)directory.getProject()).createFileFromText(fileName, StdFileTypes.GUI_DESIGNER_FORM, (CharSequence)formBody);
            createdFile = directory.add((PsiElement)formFile);
            if (this.myLastClassName != null) {
                newClass = JavaDirectoryService.getInstance().createClass(directory, this.myLastClassName);
            }
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY != null) return psiElementArray;
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/actions/CreateFormAction.create must not return null");
        }
        if (newClass != null) {
            PsiElement[] psiElementArray2 = new PsiElement[]{newClass.getContainingFile(), createdFile};
            psiElementArray = psiElementArray2;
            if (psiElementArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/actions/CreateFormAction.create must not return null");
            return psiElementArray;
        }
        PsiElement[] psiElementArray3 = new PsiElement[]{createdFile};
        psiElementArray = psiElementArray3;
        if (psiElementArray3 == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/actions/CreateFormAction.create must not return null");
        return psiElementArray;
    }

    protected String getErrorTitle() {
        return UIDesignerBundle.message("error.cannot.create.form", new Object[0]);
    }

    protected String getCommandName() {
        return UIDesignerBundle.message("command.create.form", new Object[0]);
    }

    private class MyDialog
    extends DialogWrapper {
        private JPanel myTopPanel;
        private JTextField myFormNameTextField;
        private JCheckBox myCreateBoundClassCheckbox;
        private JTextField myClassNameTextField;
        private JComboBox myBaseLayoutManagerCombo;
        private boolean myAdjusting;
        private boolean myNeedAdjust;
        private final Project myProject;
        private final CreateElementActionBase.MyInputValidator myValidator;

        public MyDialog(Project project, CreateElementActionBase.MyInputValidator validator) {
            super(project, true);
            this.myAdjusting = false;
            this.myNeedAdjust = true;
            this.myProject = project;
            this.myValidator = validator;
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(UIDesignerBundle.message("title.new.gui.form", new Object[0]));
            this.setOKActionEnabled(false);
            this.myCreateBoundClassCheckbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MyDialog.this.myClassNameTextField.setEnabled(MyDialog.this.myCreateBoundClassCheckbox.isSelected());
                }
            });
            this.myFormNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    MyDialog.this.setOKActionEnabled(MyDialog.this.myFormNameTextField.getText().length() > 0);
                    if (MyDialog.this.myNeedAdjust) {
                        MyDialog.this.myAdjusting = true;
                        MyDialog.this.myClassNameTextField.setText(MyDialog.this.myFormNameTextField.getText());
                        MyDialog.this.myAdjusting = false;
                    }
                }
            });
            this.myClassNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (!MyDialog.this.myAdjusting) {
                        MyDialog.this.myNeedAdjust = false;
                    }
                }
            });
            this.myBaseLayoutManagerCombo.setModel(new DefaultComboBoxModel<String>(LayoutManagerRegistry.getNonDeprecatedLayoutManagerNames()));
            this.myBaseLayoutManagerCombo.setRenderer(new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    this.append(LayoutManagerRegistry.getLayoutManagerDisplayName((String)value), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            });
            this.myBaseLayoutManagerCombo.setSelectedItem(GuiDesignerConfiguration.getInstance((Project)project).DEFAULT_LAYOUT_MANAGER);
        }

        protected JComponent createCenterPanel() {
            return this.myTopPanel;
        }

        protected void doOKAction() {
            if (this.myCreateBoundClassCheckbox.isSelected()) {
                CreateFormAction.this.myLastClassName = this.myClassNameTextField.getText();
            } else {
                CreateFormAction.this.myLastClassName = null;
            }
            CreateFormAction.this.myLastLayoutManager = (String)this.myBaseLayoutManagerCombo.getSelectedItem();
            GuiDesignerConfiguration.getInstance((Project)this.myProject).DEFAULT_LAYOUT_MANAGER = CreateFormAction.this.myLastLayoutManager;
            String inputString = this.myFormNameTextField.getText().trim();
            if (this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                this.close(0);
            }
            this.close(0);
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myFormNameTextField;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JComboBox jComboBox;
            JTextField jTextField;
            JCheckBox jCheckBox;
            JTextField jTextField2;
            JPanel jPanel;
            this.myTopPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("new.form.form.name.label"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myFormNameTextField = jTextField2 = new JTextField();
            jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myCreateBoundClassCheckbox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.create.bound.class"));
            jCheckBox.setSelected(true);
            jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("new.form.class.name.label"));
            jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            this.myClassNameTextField = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("new.form.base.layout.manager.label"));
            jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myBaseLayoutManagerCombo = jComboBox = new JComboBox();
            jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            jLabel.setLabelFor(jTextField2);
            jLabel2.setLabelFor(jTextField);
            jLabel3.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myTopPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

