/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectClasspathTraversing;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public final class LoaderFactory {
    private final Project myProject;
    private final WeakHashMap<Module, ClassLoader> myModule2ClassLoader;
    private ClassLoader myProjectClassLoader = null;
    private final MessageBusConnection myConnection;

    public static LoaderFactory getInstance(Project project) {
        return (LoaderFactory)ServiceManager.getService((Project)project, LoaderFactory.class);
    }

    public LoaderFactory(Project project) {
        this.myProject = project;
        this.myModule2ClassLoader = new WeakHashMap();
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                LoaderFactory.this.clearClassLoaderCache();
            }
        });
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                LoaderFactory.this.myConnection.disconnect();
                LoaderFactory.this.myModule2ClassLoader.clear();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ClassLoader getLoader(VirtualFile formFile) {
        ClassLoader classLoader;
        Module module = ModuleUtil.findModuleForFile((VirtualFile)formFile, (Project)this.myProject);
        if (module == null) {
            classLoader = this.getClass().getClassLoader();
            if (classLoader == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/LoaderFactory.getLoader must not return null");
            return classLoader;
        }
        classLoader = this.getLoader(module);
        if (classLoader != null) return classLoader;
        throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/LoaderFactory.getLoader must not return null");
    }

    public ClassLoader getLoader(Module module) {
        ClassLoader cachedLoader = this.myModule2ClassLoader.get(module);
        if (cachedLoader != null) {
            return cachedLoader;
        }
        String runClasspath = ProjectRootsTraversing.collectRoots((Module)module, (ProjectRootsTraversing.RootTraversePolicy)ProjectClasspathTraversing.FULL_CLASSPATH_RECURSIVE).getPathsString();
        ClassLoader classLoader = LoaderFactory.createClassLoader(runClasspath);
        this.myModule2ClassLoader.put(module, classLoader);
        return classLoader;
    }

    @NotNull
    public ClassLoader getProjectClassLoader() {
        if (this.myProjectClassLoader == null) {
            String runClasspath = ProjectRootsTraversing.collectRoots((Project)this.myProject, (ProjectRootsTraversing.RootTraversePolicy)ProjectClasspathTraversing.FULL_CLASSPATH_RECURSIVE).getPathsString();
            this.myProjectClassLoader = LoaderFactory.createClassLoader(runClasspath);
        }
        ClassLoader classLoader = this.myProjectClassLoader;
        if (classLoader == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/LoaderFactory.getProjectClassLoader must not return null");
        }
        return classLoader;
    }

    private static ClassLoader createClassLoader(String runClasspath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        JarFileSystemImpl fileSystem = (JarFileSystemImpl)JarFileSystem.getInstance();
        StringTokenizer tokenizer = new StringTokenizer(runClasspath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            try {
                VirtualFile vFile = manager.findFileByUrl(VfsUtil.pathToUrl((String)s));
                File realFile = fileSystem.getMirroredFile(vFile);
                urls.add(realFile != null ? realFile.toURI().toURL() : new File(s).toURI().toURL());
            }
            catch (Exception e) {}
        }
        try {
            urls.add(new File(PathUtil.getJarPathForClass(Spacer.class)).toURI().toURL());
        }
        catch (MalformedURLException ignored) {
            // empty catch block
        }
        URL[] _urls = urls.toArray(new URL[urls.size()]);
        return new DesignTimeClassLoader(Arrays.asList(_urls), null);
    }

    public void clearClassLoaderCache() {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Iterator it = uiDefaults.keySet().iterator();
        while (it.hasNext()) {
            ClassLoader loader;
            Object key = it.next();
            Object value = uiDefaults.get(key);
            if (!(value instanceof Class) || !((loader = ((Class)value).getClassLoader()) instanceof DesignTimeClassLoader)) continue;
            it.remove();
        }
        this.myModule2ClassLoader.clear();
        this.myProjectClassLoader = null;
    }

    private static class DesignTimeClassLoader
    extends UrlClassLoader {
        public DesignTimeClassLoader(List<URL> urls, ClassLoader parent) {
            super(urls, parent);
        }
    }
}

