/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFilesManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyReferenceBase
implements PsiPolyVariantReference,
EmptyResolveMessageProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.references.PropertyReferenceBase");
    protected final String myKey;
    protected final PsiElement myElement;
    protected boolean mySoft;
    private final TextRange myTextRange;

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReferenceBase.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReferenceBase.<init> must not be null");
        }
        this(key, soft, element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element, TextRange range) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReferenceBase.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReferenceBase.<init> must not be null");
        }
        this.myKey = key;
        this.mySoft = soft;
        this.myElement = element;
        this.myTextRange = range;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    protected String getKeyText() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/PropertyReferenceBase.getKeyText must not return null");
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyReferenceBase other = (PropertyReferenceBase)o;
        return this.getElement() == other.getElement() && this.getKeyText().equals(other.getKeyText());
    }

    public int hashCode() {
        return this.getKeyText().hashCode();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/PropertyReferenceBase.getElement must not return null");
        }
        return psiElement;
    }

    public TextRange getRangeInElement() {
        return this.myTextRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/PropertyReferenceBase.getCanonicalText must not return null");
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        if (manipulator == null) {
            LOG.error("Cannot find manipulator for " + this.myElement + " of class " + this.myElement.getClass());
        }
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/references/PropertyReferenceBase.bindToElement must not be null");
        }
        throw new IncorrectOperationException("not implemented");
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof Property)) {
            return false;
        }
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement el = result.getElement();
            if (el == null || !el.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    protected void addKey(Object property, Set<Object> variants) {
        variants.add(property);
    }

    protected void addVariantsFromFile(PropertiesFile propertiesFile, Set<Object> variants) {
        if (propertiesFile == null) {
            return;
        }
        List<Property> properties = propertiesFile.getProperties();
        for (Property property : properties) {
            this.addKey(property, variants);
        }
    }

    protected void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    public String getUnresolvedMessagePattern() {
        return PropertiesBundle.message("unresolved.property.key", new Object[0]);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        List<Object> properties;
        String key = this.getKeyText();
        List<PropertiesFile> propertiesFiles = this.getPropertiesFiles();
        if (propertiesFiles == null) {
            properties = PropertiesUtil.findPropertiesByKey(this.getElement().getProject(), key);
        } else {
            properties = new ArrayList();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                properties.addAll(propertiesFile.findPropertiesByKey(key));
            }
        }
        ContainerUtil.quickSort(properties, (Comparator)new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                String name1 = o1.getContainingFile().getName();
                String name2 = o2.getContainingFile().getName();
                return Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
            }
        });
        ResolveResult[] result = new ResolveResult[properties.size()];
        int i = 0;
        for (Property property : properties) {
            result[i++] = new PsiElementResolveResult((PsiElement)property);
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/PropertyReferenceBase.multiResolve must not return null");
        }
        return result;
    }

    @Nullable
    protected abstract List<PropertiesFile> getPropertiesFiles();

    @NotNull
    public Object[] getVariants() {
        THashSet variants = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Object>(){

            public int computeHashCode(Object object) {
                if (object instanceof Property) {
                    String key = ((Property)object).getKey();
                    return key == null ? 0 : key.hashCode();
                }
                return 0;
            }

            public boolean equals(Object o1, Object o2) {
                return o1 instanceof Property && o2 instanceof Property && Comparing.equal((String)((Property)o1).getKey(), (String)((Property)o2).getKey(), (boolean)true);
            }
        });
        List<PropertiesFile> propertiesFileList = this.getPropertiesFiles();
        if (propertiesFileList == null) {
            final PsiManager psiManager = this.myElement.getManager();
            final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)psiManager.getProject()).getFileIndex();
            PropertiesFilesManager.getInstance(this.myElement.getProject()).processAllPropertiesFiles(new Processor<VirtualFile>((Set)variants){
                final /* synthetic */ Set val$variants;
                {
                    this.val$variants = set;
                }

                public boolean process(VirtualFile file) {
                    if (!file.isValid()) {
                        return true;
                    }
                    if (!fileIndex.isInContent(file)) {
                        return true;
                    }
                    PsiFile psiFile = psiManager.findFile(file);
                    if (!(psiFile instanceof PropertiesFile)) {
                        return true;
                    }
                    PropertiesFile propertiesFile = (PropertiesFile)psiFile;
                    PropertyReferenceBase.this.addVariantsFromFile(propertiesFile, this.val$variants);
                    return true;
                }
            });
        } else {
            for (PropertiesFile propFile : propertiesFileList) {
                this.addVariantsFromFile(propFile, (Set<Object>)variants);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/references/PropertyReferenceBase.getVariants must not return null");
        }
        return objectArray;
    }
}

