/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertiesStubElementImpl;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyImpl
extends PropertiesStubElementImpl<PropertyStub>
implements Property {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.psi.impl.PropertyImpl");

    public PropertyImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertyImpl.<init> must not be null");
        }
        super(node);
    }

    public PropertyImpl(PropertyStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public String toString() {
        return "Property:" + this.getKey();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertyImpl.setName must not be null");
        }
        PropertyImpl property = (PropertyImpl)PropertiesElementFactory.createProperty(this.getProject(), name, "xxx");
        ASTNode keyNode = this.getKeyNode();
        ASTNode newKeyNode = property.getKeyNode();
        LOG.assertTrue(newKeyNode != null);
        if (keyNode == null) {
            this.getNode().addChild(newKeyNode);
        } else {
            this.getNode().replaceChild(keyNode, newKeyNode);
        }
        return this;
    }

    @Override
    public void setValue(@NotNull String value) throws IncorrectOperationException {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/psi/impl/PropertyImpl.setValue must not be null");
        }
        String escapedName = PropertiesElementFactory.escapeValue(value);
        ASTNode node = this.getValueNode();
        PropertyImpl property = (PropertyImpl)PropertiesElementFactory.createProperty(this.getProject(), "xxx", escapedName);
        ASTNode valueNode = property.getValueNode();
        if (node == null) {
            if (valueNode != null) {
                this.getNode().addChild(valueNode);
            }
        } else if (valueNode == null) {
            this.getNode().removeChild(node);
        } else {
            this.getNode().replaceChild(node, valueNode);
        }
    }

    public String getName() {
        return this.getUnescapedKey();
    }

    @Override
    public String getKey() {
        PropertyStub stub = (PropertyStub)this.getStub();
        if (stub != null) {
            return stub.getKey();
        }
        ASTNode node = this.getKeyNode();
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    @Nullable
    public ASTNode getKeyNode() {
        return this.getNode().findChildByType(PropertiesTokenTypes.KEY_CHARACTERS);
    }

    @Nullable
    public ASTNode getValueNode() {
        return this.getNode().findChildByType(PropertiesTokenTypes.VALUE_CHARACTERS);
    }

    @Override
    public String getValue() {
        ASTNode node = this.getValueNode();
        if (node == null) {
            return "";
        }
        return node.getText();
    }

    @Override
    @Nullable
    public String getUnescapedValue() {
        return PropertyImpl.unescape(this.getValue());
    }

    public static String unescape(String s) {
        if (s == null) {
            return null;
        }
        int off = 0;
        int len = s.length();
        StringBuilder out = new StringBuilder();
        while (off < len) {
            char aChar;
            if ((aChar = s.charAt(off++)) == '\\') {
                if ((aChar = s.charAt(off++)) == 'u') {
                    int value = 0;
                    boolean error = false;
                    block6: for (int i = 0; i < 4 && off < s.length(); ++i) {
                        aChar = s.charAt(off++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                out.append("\\u");
                                int start = off - i - 1;
                                int end = start + 4 < s.length() ? start + 4 : s.length();
                                out.append(s, start, end);
                                i = 4;
                                error = true;
                                off = end;
                            }
                        }
                    }
                    if (error) continue;
                    out.append((char)value);
                    continue;
                }
                if (aChar == '\n') {
                    while (off < len && (s.charAt(off) == ' ' || s.charAt(off) == '\t')) {
                        ++off;
                    }
                    continue;
                }
                if (aChar == 't') {
                    out.append('\t');
                    continue;
                }
                if (aChar == 'r') {
                    out.append('\r');
                    continue;
                }
                if (aChar == 'n') {
                    out.append('\n');
                    continue;
                }
                if (aChar == 'f') {
                    out.append('\f');
                    continue;
                }
                out.append(aChar);
                continue;
            }
            out.append(aChar);
        }
        return out.toString();
    }

    public static TextRange trailingSpaces(String s) {
        if (s == null) {
            return null;
        }
        int off = 0;
        int len = s.length();
        int startSpaces = -1;
        while (off < len) {
            char aChar;
            if ((aChar = s.charAt(off++)) == '\\') {
                if (startSpaces == -1) {
                    startSpaces = off - 1;
                }
                if ((aChar = s.charAt(off++)) == 'u') {
                    int value = 0;
                    boolean error = false;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = s.charAt(off++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                int start = off - i - 1;
                                int end = start + 4 < s.length() ? start + 4 : s.length();
                                i = 4;
                                error = true;
                                off = end;
                                startSpaces = -1;
                            }
                        }
                    }
                    if (error) continue;
                    if (Character.isWhitespace(value)) {
                        if (startSpaces != -1) continue;
                        startSpaces = off - 1;
                        continue;
                    }
                    startSpaces = -1;
                    continue;
                }
                if (aChar == '\n') {
                    while (off < len && (s.charAt(off) == ' ' || s.charAt(off) == '\t')) {
                        ++off;
                    }
                    continue;
                }
                if (aChar == 't') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (aChar == 'r') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (aChar == 'n') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (aChar == 'f') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (Character.isWhitespace(aChar)) {
                    if (startSpaces != -1) continue;
                    startSpaces = off - 1;
                    continue;
                }
                startSpaces = -1;
                continue;
            }
            if (Character.isWhitespace(aChar)) {
                if (startSpaces != -1) continue;
                startSpaces = off - 1;
                continue;
            }
            startSpaces = -1;
        }
        return startSpaces == -1 ? null : new TextRange(startSpaces, len);
    }

    @Override
    @Nullable
    public String getUnescapedKey() {
        return PropertyImpl.unescape(this.getKey());
    }

    @Override
    @Nullable
    public String getKeyValueSeparator() {
        ASTNode node = this.getNode().findChildByType(PropertiesTokenTypes.KEY_VALUE_SEPARATOR);
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    public Icon getIcon(int flags) {
        return Icons.PROPERTY_ICON;
    }

    public void delete() throws IncorrectOperationException {
        ASTNode parentNode = this.getParent().getNode();
        assert (parentNode != null);
        ASTNode node = this.getNode();
        ASTNode prev = node.getTreePrev();
        ASTNode next = node.getTreeNext();
        parentNode.removeChild(node);
        if ((prev == null || prev.getElementType() == TokenType.WHITE_SPACE) && next != null && next.getElementType() == TokenType.WHITE_SPACE) {
            parentNode.removeChild(next);
        }
    }

    @Override
    public PropertiesFile getContainingFile() {
        return (PropertiesFile)super.getContainingFile();
    }

    @Override
    public String getDocCommentText() {
        StringBuilder text = new StringBuilder();
        for (PsiElement doc = this.getPrevSibling(); doc != null; doc = doc.getPrevSibling()) {
            if (doc instanceof PsiWhiteSpace) {
                doc = doc.getPrevSibling();
            }
            if (!(doc instanceof PsiComment)) break;
            if (text.length() != 0) {
                text.append("\n");
            }
            String comment = doc.getText();
            String trimmed = StringUtil.trimStart((String)StringUtil.trimStart((String)comment, (String)"#"), (String)"!");
            text.append(trimmed.trim());
        }
        if (text.length() == 0) {
            return null;
        }
        return text.toString();
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/psi/impl/PropertyImpl.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PropertyImpl.this.getName();
            }

            public String getLocationString() {
                return PropertyImpl.this.getContainingFile().getName();
            }

            public Icon getIcon(boolean open) {
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                return null;
            }
        };
    }
}

