/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.projectView.ResourceBundleDeleteProvider;
import com.intellij.lang.properties.projectView.ResourceBundleNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ResourceBundleGrouper
implements TreeStructureProvider,
DumbAware {
    private final Project myProject;

    public ResourceBundleGrouper(Project project) {
        this.myProject = project;
    }

    public Collection<AbstractTreeNode> modify(AbstractTreeNode parent, Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent instanceof ResourceBundleNode) {
            return children;
        }
        THashMap childBundles = new THashMap();
        for (AbstractTreeNode child : children) {
            Object f = child.getValue();
            if (!(f instanceof PropertiesFile)) continue;
            PropertiesFile propertiesFile = (PropertiesFile)f;
            ResourceBundle bundle = propertiesFile.getResourceBundle();
            Collection files = (Collection)childBundles.get(bundle);
            if (files == null) {
                files = new SmartList();
                childBundles.put(bundle, files);
            }
            files.add(propertiesFile);
        }
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (Map.Entry entry : childBundles.entrySet()) {
            ResourceBundle resourceBundle = (ResourceBundle)entry.getKey();
            Collection files = (Collection)entry.getValue();
            if (files.size() == 1) continue;
            result.add((AbstractTreeNode)new ResourceBundleNode(this.myProject, resourceBundle, settings));
        }
        for (AbstractTreeNode child : children) {
            PropertiesFile propertiesFile;
            ResourceBundle bundle;
            Object f = child.getValue();
            if (f instanceof PropertiesFile && ((Collection)childBundles.get(bundle = (propertiesFile = (PropertiesFile)f).getResourceBundle())).size() != 1) continue;
            result.add(child);
        }
        return result;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        if (selected == null) {
            return null;
        }
        for (AbstractTreeNode selectedElement : selected) {
            Object element = selectedElement.getValue();
            if (PlatformDataKeys.VIRTUAL_FILE.is(dataName) && element instanceof ResourceBundle) {
                return new ResourceBundleAsVirtualFile((ResourceBundle)element);
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataName) && element instanceof ResourceBundle) {
                List<PropertiesFile> propertiesFiles = ((ResourceBundle)element).getPropertiesFiles(this.myProject);
                return propertiesFiles.toArray(new PropertiesFile[propertiesFiles.size()]);
            }
            if (!PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataName) || !(element instanceof ResourceBundle)) continue;
            return new ResourceBundleDeleteProvider((ResourceBundle)element);
        }
        if (ResourceBundle.ARRAY_DATA_KEY.is(dataName)) {
            ArrayList<ResourceBundle> selectedElements = new ArrayList<ResourceBundle>();
            for (AbstractTreeNode node : selected) {
                Object value = node.getValue();
                if (!(value instanceof ResourceBundle)) continue;
                selectedElements.add((ResourceBundle)value);
            }
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ResourceBundle[selectedElements.size()]);
        }
        return null;
    }
}

