/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenMergingUpdateQueue
extends MergingUpdateQueue {
    private final AtomicInteger mySuspendCounter = new AtomicInteger(0);

    public MavenMergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, Disposable parent) {
        this(name, mergingTimeSpan, isActive, ANY_COMPONENT, parent);
    }

    public MavenMergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent, Disposable parent) {
        super(name, mergingTimeSpan, isActive, modalityStateComponent, parent, null, false);
    }

    public void queue(Update update) {
        boolean passThrough = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            passThrough = this.isPassThrough();
        } else if (MavenUtil.isNoBackgroundMode()) {
            passThrough = true;
        }
        if (passThrough) {
            update.run();
            return;
        }
        super.queue(update);
    }

    public void makeUserAware(final Project project) {
        new ReadAction(){

            protected void run(Result result) throws Throwable {
                EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
                multicaster.addCaretListener(new CaretListener(){

                    public void caretPositionChanged(CaretEvent e) {
                        MavenMergingUpdateQueue.this.restartTimer();
                    }
                }, (Disposable)MavenMergingUpdateQueue.this);
                multicaster.addDocumentListener((DocumentListener)new DocumentAdapter(){

                    public void documentChanged(DocumentEvent event) {
                        MavenMergingUpdateQueue.this.restartTimer();
                    }
                }, (Disposable)MavenMergingUpdateQueue.this);
                ProjectRootManager.getInstance((Project)project).addModuleRootListener(new ModuleRootListener(){
                    boolean beforeCalled = false;

                    public void beforeRootsChange(ModuleRootEvent event) {
                        MavenMergingUpdateQueue.this.suspend();
                        this.beforeCalled = true;
                    }

                    public void rootsChanged(ModuleRootEvent event) {
                        if (!this.beforeCalled) {
                            return;
                        }
                        this.beforeCalled = false;
                        MavenMergingUpdateQueue.this.resume();
                        MavenMergingUpdateQueue.this.restartTimer();
                    }
                }, (Disposable)MavenMergingUpdateQueue.this);
            }
        }.execute();
    }

    public void makeDumbAware(final Project project) {
        new ReadAction(){

            protected void run(Result result) throws Throwable {
                MessageBusConnection connection = project.getMessageBus().connect((Disposable)MavenMergingUpdateQueue.this);
                connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                    public void enteredDumbMode() {
                        MavenMergingUpdateQueue.this.suspend();
                    }

                    public void exitDumbMode() {
                        MavenMergingUpdateQueue.this.resume();
                    }
                });
                if (DumbService.getInstance((Project)project).isDumb()) {
                    MavenMergingUpdateQueue.this.suspend();
                }
            }
        }.execute();
    }

    public void makeModalAware(Project project) {
        MavenUtil.invokeAndWait(project, new Runnable(){

            @Override
            public void run() {
                final ModalityStateListener listener = new ModalityStateListener(){

                    public void beforeModalityStateChanged(boolean entering) {
                        if (entering) {
                            MavenMergingUpdateQueue.this.suspend();
                        } else {
                            MavenMergingUpdateQueue.this.resume();
                        }
                    }
                };
                LaterInvocator.addModalityStateListener((ModalityStateListener)listener);
                if (MavenUtil.isInModalContext()) {
                    MavenMergingUpdateQueue.this.suspend();
                }
                Disposer.register((Disposable)MavenMergingUpdateQueue.this, (Disposable)new Disposable(){

                    public void dispose() {
                        LaterInvocator.removeModalityStateListener((ModalityStateListener)listener);
                    }
                });
            }
        });
    }

    public void suspend() {
        assert (this.mySuspendCounter.get() >= 0);
        if (this.mySuspendCounter.incrementAndGet() == 1) {
            super.suspend();
        }
    }

    public void resume() {
        assert (this.mySuspendCounter.get() > 0);
        if (this.mySuspendCounter.decrementAndGet() == 0) {
            super.resume();
        }
    }
}

