/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class RunBuildAction
extends MavenAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && this.checkOrPerform(e, false);
    }

    public void actionPerformed(AnActionEvent e) {
        this.checkOrPerform(e, true);
    }

    private boolean checkOrPerform(AnActionEvent e, boolean perform) {
        MavenProject project = MavenActionUtil.getMavenProject(e);
        if (project == null) {
            return false;
        }
        List goals = (List)e.getData(MavenDataKeys.MAVEN_GOALS);
        if (goals == null || goals.isEmpty()) {
            return false;
        }
        if (!perform) {
            return true;
        }
        MavenRunnerParameters params = new MavenRunnerParameters(true, project.getDirectory(), goals, MavenActionUtil.getProjectsManager(e).getExplicitProfiles());
        MavenRunConfigurationType.runConfiguration(MavenActionUtil.getProject(e), params, e.getDataContext(), null);
        return true;
    }
}

