/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVcsSettings;
import git4idea.merge.MergeChangeCollector;
import git4idea.update.GitBaseRebaseProcess;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class GitUpdateProcess
extends GitBaseRebaseProcess {
    private GitVcsSettings mySettings;
    private UpdatedFiles myUpdatedFiles;
    private GitRevisionNumber myBefore;

    public GitUpdateProcess(Project project, GitVcsSettings settings, GitVcs vcs, UpdatedFiles updatedFiles, List<VcsException> exceptions) {
        super(vcs, project, exceptions);
        this.mySettings = settings;
        this.myUpdatedFiles = updatedFiles;
    }

    @Override
    protected GitLineHandler makeStartHandler(VirtualFile root) {
        GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.PULL);
        h.ignoreErrorCode(1);
        switch (this.mySettings.getUpdateType()) {
            case REBASE: {
                h.addParameters("--rebase");
                break;
            }
            case MERGE: {
                h.addParameters("--no-rebase");
                break;
            }
            case BRANCH_DEFAULT: {
                break;
            }
            default: {
                assert (false) : "Unknown update type: " + (Object)((Object)this.mySettings.getUpdateType());
                break;
            }
        }
        h.addParameters("--no-stat");
        h.addParameters("-v");
        return h;
    }

    @Override
    protected void markStart(VirtualFile root) throws VcsException {
        this.myBefore = GitRevisionNumber.resolve(this.myProject, root, "HEAD");
    }

    @Override
    protected void markEnd(VirtualFile root, boolean cancelled) {
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, root, this.myBefore, this.myUpdatedFiles);
        collector.collect(this.myExceptions);
    }

    @Override
    protected boolean isAutoStash() {
        return this.mySettings.isStashOnUpdate();
    }

    @Override
    protected String makeStashMessage() {
        return "Uncommitted changes before update operation at " + DateFormat.getDateTimeInstance(3, 3, Locale.US).format(new Date());
    }
}

