/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.update.GitUpdateConfigurable;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateEnvironment
implements UpdateEnvironment {
    private GitVcs myVcs;
    private final Project myProject;
    private final GitVcsSettings mySettings;

    public GitUpdateEnvironment(@NotNull Project project, @NotNull GitVcs vcs, GitVcsSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/update/GitUpdateEnvironment.<init> must not be null");
        }
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/update/GitUpdateEnvironment.<init> must not be null");
        }
        this.myVcs = vcs;
        this.myProject = project;
        this.mySettings = settings;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> sequentialUpdatesContextRef) throws ProcessCanceledException {
        if (filePaths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/update/GitUpdateEnvironment.updateDirectories must not be null");
        }
        if (sequentialUpdatesContextRef == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/update/GitUpdateEnvironment.updateDirectories must not be null");
        }
        Set<VirtualFile> roots = GitUtil.gitRoots(Arrays.asList(filePaths));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        new GitUpdateProcess(this.myProject, this.mySettings, this.myVcs, updatedFiles, exceptions).doUpdate(progressIndicator, roots);
        GitUpdateSession gitUpdateSession = new GitUpdateSession(exceptions);
        if (gitUpdateSession == null) {
            throw new IllegalStateException("@NotNull method git4idea/update/GitUpdateEnvironment.updateDirectories must not return null");
        }
        return gitUpdateSession;
    }

    public boolean validateOptions(Collection<FilePath> filePaths) {
        for (FilePath p : filePaths) {
            if (GitUtil.isUnderGit(p)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return new GitUpdateConfigurable(this.mySettings);
    }
}

