/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.GitBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.ui.GitConvertFilesDialog;
import git4idea.ui.GitUIUtil;
import git4idea.update.GitStashUtils;
import git4idea.update.GitUpdateLocallyModifiedDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;

public abstract class GitBaseRebaseProcess {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.update.GitUpdateProcess");
    protected Project myProject;
    protected GitVcs myVcs;
    protected List<VcsException> myExceptions;

    public GitBaseRebaseProcess(GitVcs vcs, Project project, List<VcsException> exceptions) {
        this.myVcs = vcs;
        this.myProject = project;
        this.myExceptions = exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(ProgressIndicator progressIndicator, Set<VirtualFile> roots) {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        projectManager.blockReloadingProjectOnExternalChanges();
        try {
            HashSet<VirtualFile> rootsToStash = new HashSet<VirtualFile>();
            List listsCopy = null;
            ChangeListManagerEx changeManager = (ChangeListManagerEx)ChangeListManagerEx.getInstance((Project)this.myProject);
            HashMap<VirtualFile, List<Change>> sortedChanges = new HashMap<VirtualFile, List<Change>>();
            if (this.isAutoStash()) {
                listsCopy = changeManager.getChangeListsCopy();
                for (LocalChangeList l : listsCopy) {
                    Collection changeCollection = l.getChanges();
                    LOG.debug("Stashing " + changeCollection.size() + " changes from '" + l.getName() + "'");
                    for (Change c : changeCollection) {
                        VirtualFile r;
                        if (c.getAfterRevision() != null) {
                            r = GitUtil.getGitRootOrNull(c.getAfterRevision().getFile());
                            if (r == null) continue;
                            rootsToStash.add(r);
                            ArrayList<Change> changes = (ArrayList<Change>)sortedChanges.get(r);
                            if (changes == null) {
                                changes = new ArrayList<Change>();
                                sortedChanges.put(r, changes);
                            }
                            changes.add(c);
                            continue;
                        }
                        if (c.getBeforeRevision() == null || (r = GitUtil.getGitRootOrNull(c.getBeforeRevision().getFile())) == null) continue;
                        rootsToStash.add(r);
                    }
                }
                GitVcsSettings settings = GitVcsSettings.getInstance(this.myProject);
                boolean result = GitConvertFilesDialog.showDialogIfNeeded(this.myProject, settings, sortedChanges, this.myExceptions);
                if (!result) {
                    if (this.myExceptions.isEmpty()) {
                        this.myExceptions.add(new VcsException("Conversion of line separators failed."));
                    }
                    return;
                }
            }
            if (this.areRootsUnderRebase(roots)) {
                return;
            }
            String stashMessage = this.makeStashMessage();
            for (final VirtualFile root : roots) {
                try {
                    String value;
                    GitBranch branch = GitBranch.current(this.myProject, root);
                    if (branch == null || (value = branch.getTrackedRemoteName(this.myProject, root)) == null || value.length() == 0) continue;
                    Ref cancelled = new Ref((Object)false);
                    Ref ex = new Ref();
                    try {
                        boolean stashCreated = false;
                        if (rootsToStash.contains(root)) {
                            progressIndicator.setText(GitHandlerUtil.formatOperationName("Stashing changes from", root));
                            stashCreated = GitStashUtils.saveStash(this.myProject, root, stashMessage);
                        }
                        try {
                            this.markStart(root);
                            try {
                                GitLineHandler h = this.makeStartHandler(root);
                                RebaseConflictDetector rebaseConflictDetector = new RebaseConflictDetector();
                                h.addLineListener(rebaseConflictDetector);
                                try {
                                    GitHandlerUtil.doSynchronouslyWithExceptions(h, progressIndicator, GitHandlerUtil.formatOperationName("Pulling changes into", root));
                                }
                                finally {
                                    if (!rebaseConflictDetector.isRebaseConflict()) {
                                        this.myExceptions.addAll(h.errors());
                                    }
                                    this.cleanupHandler(root, h);
                                }
                                block27: while (rebaseConflictDetector.isRebaseConflict() && !((Boolean)cancelled.get()).booleanValue()) {
                                    this.mergeFiles(root, (Ref<Boolean>)cancelled, (Ref<Throwable>)ex);
                                    if (ex.get() != null) {
                                        throw GitUtil.rethrowVcsException((Throwable)ex.get());
                                    }
                                    this.checkLocallyModified(root, (Ref<Boolean>)cancelled, (Ref<Throwable>)ex);
                                    if (ex.get() != null) {
                                        throw GitUtil.rethrowVcsException((Throwable)ex.get());
                                    }
                                    if (((Boolean)cancelled.get()).booleanValue()) break;
                                    this.doRebase(progressIndicator, root, rebaseConflictDetector, "--continue");
                                    final Ref result = new Ref();
                                    block28: while (rebaseConflictDetector.isNoChange()) {
                                        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                int rc = Messages.showDialog((Project)GitBaseRebaseProcess.this.myProject, (String)GitBundle.message("update.rebase.no.change", root.getPresentableUrl()), (String)GitBundle.getString("update.rebase.no.change.title"), (String[])new String[]{GitBundle.getString("update.rebase.no.change.skip"), GitBundle.getString("update.rebase.no.change.retry"), GitBundle.getString("update.rebase.no.change.cancel")}, (int)0, (Icon)Messages.getErrorIcon());
                                                result.set((Object)rc);
                                            }
                                        });
                                        switch ((Integer)result.get()) {
                                            case 0: {
                                                this.doRebase(progressIndicator, root, rebaseConflictDetector, "--skip");
                                                continue block28;
                                            }
                                            case 1: {
                                                continue block28;
                                            }
                                            case 2: {
                                                cancelled.set((Object)true);
                                                continue block27;
                                            }
                                        }
                                    }
                                }
                                if (!((Boolean)cancelled.get()).booleanValue()) continue;
                                this.myExceptions.add(new VcsException("The update process was cancelled for " + root.getPresentableUrl()));
                                this.doRebase(progressIndicator, root, rebaseConflictDetector, "--abort");
                            }
                            finally {
                                this.markEnd(root, (Boolean)cancelled.get());
                            }
                        }
                        finally {
                            if (!stashCreated) continue;
                            progressIndicator.setText(GitHandlerUtil.formatOperationName("Unstashing changes to", root));
                            this.unstash(listsCopy, changeManager, root);
                        }
                    }
                    finally {
                        if (listsCopy == null) continue;
                        HashSet<File> filesToRefresh = new HashSet<File>();
                        VcsDirtyScopeManager m = VcsDirtyScopeManager.getInstance((Project)this.myProject);
                        for (LocalChangeList changeList : listsCopy) {
                            Collection changes = changeList.getChanges();
                            if (!changes.isEmpty()) {
                                LOG.debug("After unstash: moving " + changes.size() + " changes to '" + changeList.getName() + "'");
                                changeManager.moveChangesTo(changeList, changes.toArray(new Change[changes.size()]));
                            }
                            for (Change c : changeList.getChanges()) {
                                ContentRevision before;
                                ContentRevision after = c.getAfterRevision();
                                if (after != null) {
                                    m.fileDirty(after.getFile());
                                    filesToRefresh.add(after.getFile().getIOFile());
                                }
                                if ((before = c.getBeforeRevision()) == null) continue;
                                m.fileDirty(before.getFile());
                                filesToRefresh.add(before.getFile().getIOFile());
                            }
                        }
                        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
                        this.mergeFiles(root, (Ref<Boolean>)cancelled, (Ref<Throwable>)ex);
                        if (ex.get() == null) continue;
                        this.myExceptions.add(GitUtil.rethrowVcsException((Throwable)ex.get()));
                    }
                }
                catch (VcsException ex) {
                    this.myExceptions.add(ex);
                }
            }
        }
        finally {
            projectManager.unblockReloadingProjectOnExternalChanges();
        }
    }

    protected void cleanupHandler(VirtualFile root, GitLineHandler h) {
    }

    protected abstract GitLineHandler makeStartHandler(VirtualFile var1) throws VcsException;

    private void unstash(List<LocalChangeList> listsCopy, ChangeListManagerEx changeManager, VirtualFile root) {
        try {
            GitStashUtils.popLastStash(this.myProject, root);
        }
        catch (VcsException ue) {
            this.myExceptions.add(ue);
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GitUIUtil.showOperationError(GitBaseRebaseProcess.this.myProject, ue, "Auto-unstash");
                }
            });
        }
    }

    protected void markStart(VirtualFile root) throws VcsException {
    }

    protected void markEnd(VirtualFile root, boolean cancelled) {
    }

    protected abstract String makeStashMessage();

    protected abstract boolean isAutoStash();

    private boolean areRootsUnderRebase(Set<VirtualFile> roots) {
        TreeSet<VirtualFile> rebasingRoots = new TreeSet<VirtualFile>(GitUtil.VIRTUAL_FILE_COMPARATOR);
        for (VirtualFile root : roots) {
            if (!GitRebaseUtils.isRebaseInTheProgress(root)) continue;
            rebasingRoots.add(root);
        }
        if (!rebasingRoots.isEmpty()) {
            final StringBuilder files = new StringBuilder();
            for (VirtualFile r : rebasingRoots) {
                files.append(GitBundle.message("update.root.rebasing.item", r.getPresentableUrl()));
                this.myExceptions.add(new VcsException(GitBundle.message("update.root.rebasing", r.getPresentableUrl())));
            }
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)GitBaseRebaseProcess.this.myProject, (String)GitBundle.message("update.root.rebasing.message", files.toString()), (String)GitBundle.message("update.root.rebasing.title", new Object[0]));
                }
            });
            return true;
        }
        return false;
    }

    private void mergeFiles(final VirtualFile root, final Ref<Boolean> cancelled, final Ref<Throwable> ex) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List<VirtualFile> affectedFiles = GitChangeUtils.unmergedFiles(GitBaseRebaseProcess.this.myProject, root);
                    while (affectedFiles.size() != 0) {
                        int result;
                        AbstractVcsHelper.getInstance((Project)GitBaseRebaseProcess.this.myProject).showMergeDialog(affectedFiles, GitBaseRebaseProcess.this.myVcs.getMergeProvider());
                        affectedFiles = GitChangeUtils.unmergedFiles(GitBaseRebaseProcess.this.myProject, root);
                        if (affectedFiles.size() == 0 || (result = Messages.showYesNoDialog((Project)GitBaseRebaseProcess.this.myProject, (String)GitBundle.message("update.rebase.unmerged", affectedFiles.size(), root.getPresentableUrl()), (String)GitBundle.getString("update.rebase.unmerged.title"), (Icon)Messages.getErrorIcon())) == 0) continue;
                        cancelled.set((Object)true);
                        return;
                    }
                }
                catch (Throwable t) {
                    ex.set((Object)t);
                }
            }
        });
    }

    private void checkLocallyModified(final VirtualFile root, final Ref<Boolean> cancelled, final Ref<Throwable> ex) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (!GitUpdateLocallyModifiedDialog.showIfNeeded(GitBaseRebaseProcess.this.myProject, root)) {
                        cancelled.set((Object)true);
                    }
                }
                catch (Throwable t) {
                    ex.set((Object)t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebase(ProgressIndicator progressIndicator, VirtualFile root, RebaseConflictDetector rebaseConflictDetector, String action) {
        GitLineHandler rh = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
        rh.ignoreErrorCode(1);
        rh.addParameters(action);
        rebaseConflictDetector.reset();
        rh.addLineListener(rebaseConflictDetector);
        if (!"--abort".equals(action)) {
            this.configureRebaseEditor(root, rh);
        }
        try {
            GitHandlerUtil.doSynchronouslyWithExceptions(rh, progressIndicator, GitHandlerUtil.formatOperationName("Rebasing ", root));
        }
        finally {
            this.cleanupHandler(root, rh);
        }
    }

    protected void configureRebaseEditor(VirtualFile root, GitLineHandler h) {
    }

    static class RebaseConflictDetector
    extends GitLineHandlerAdapter {
        private static final String[] REBASE_CONFLICT_INDICATORS = new String[]{"When you have resolved this problem run \"git rebase --continue\".", "Automatic cherry-pick failed.  After resolving the conflicts,"};
        private static final String REBASE_NO_CHANGE_INDICATOR = "No changes - did you forget to use 'git add'?";
        AtomicBoolean rebaseConflict = new AtomicBoolean(false);
        AtomicBoolean noChange = new AtomicBoolean(false);

        RebaseConflictDetector() {
        }

        public void reset() {
            this.rebaseConflict.set(false);
            this.noChange.set(false);
        }

        public boolean isNoChange() {
            return this.noChange.get();
        }

        public boolean isRebaseConflict() {
            return this.rebaseConflict.get();
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            for (String i : REBASE_CONFLICT_INDICATORS) {
                if (!line.startsWith(i)) continue;
                this.rebaseConflict.set(true);
                break;
            }
            if (line.startsWith(REBASE_NO_CHANGE_INDICATOR)) {
                this.noChange.set(true);
            }
        }
    }
}

