/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitMergeTool
extends BasicAction {
    @Override
    public boolean perform(@NotNull Project project, GitVcs vcs, @NotNull List<VcsException> exceptions, @NotNull VirtualFile[] affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitMergeTool.perform must not be null");
        }
        if (exceptions == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitMergeTool.perform must not be null");
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of git4idea/actions/GitMergeTool.perform must not be null");
        }
        GitMergeTool.saveAll();
        ChangeListManager changes = ChangeListManager.getInstance((Project)project);
        for (VirtualFile file : affectedFiles) {
            Change change = changes.getChange(file);
            if (change == null || change.getFileStatus() == FileStatus.MERGED_WITH_CONFLICTS) continue;
            File f = new File(file.getPath());
            exceptions.add(new VcsException(GitBundle.message("merge.is.not.needed", f.getAbsolutePath())));
            return true;
        }
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog(Arrays.asList(affectedFiles), vcs.getMergeProvider());
        return false;
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("merge.tool.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/GitMergeTool.getActionName must not return null");
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull Project project, @NotNull GitVcs vcs, VirtualFile ... vFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitMergeTool.isEnabled must not be null");
        }
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitMergeTool.isEnabled must not be null");
        }
        if (vFiles == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitMergeTool.isEnabled must not be null");
        }
        FileStatusManager fs = FileStatusManager.getInstance((Project)project);
        for (VirtualFile f : vFiles) {
            if (fs.getStatus(f) == FileStatus.MERGED_WITH_CONFLICTS) continue;
            return false;
        }
        return true;
    }
}

