/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitReference;
import git4idea.GitRevisionNumber;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import git4idea.config.GitConfigUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranch
extends GitReference {
    private final boolean myRemote;
    private final boolean myActive;
    @NonNls
    public static final String NO_BRANCH_NAME = "(no branch)";
    @NonNls
    public static final String REFS_HEADS_PREFIX = "refs/heads/";
    @NonNls
    public static final String REFS_REMOTES_PREFIX = "refs/remotes/";

    public GitBranch(@NotNull String name, boolean active, boolean remote) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitBranch.<init> must not be null");
        }
        super(name);
        this.myRemote = remote;
        this.myActive = active;
    }

    public boolean isRemote() {
        return this.myRemote;
    }

    public boolean isActive() {
        return this.myActive;
    }

    @Nullable
    public static GitBranch current(Project project, VirtualFile root) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.BRANCH);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters("--no-color");
        StringTokenizer lines = new StringTokenizer(h.run(), "\n");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line == null || !line.startsWith("*")) continue;
            if (line.endsWith(NO_BRANCH_NAME)) {
                return null;
            }
            return new GitBranch(line.substring(2), true, false);
        }
        return null;
    }

    public static void listAsStrings(Project project, VirtualFile root, boolean remote, boolean local, Collection<String> branches) throws VcsException {
        if (!local && !remote) {
            return;
        }
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.BRANCH);
        handler.setNoSSH(true);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        if (remote && local) {
            handler.addParameters("-a");
        } else if (remote) {
            handler.addParameters("-r");
        }
        StringScanner s = new StringScanner(handler.run());
        while (s.hasMoreData()) {
            String line = s.line();
            if (line.length() == 0 || line.endsWith(NO_BRANCH_NAME)) continue;
            int sp = line.indexOf(32, 2);
            if (sp != -1) {
                branches.add(line.substring(2, sp));
                continue;
            }
            branches.add(line.substring(2));
        }
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = (this.myRemote ? REFS_REMOTES_PREFIX : REFS_HEADS_PREFIX) + this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitBranch.getFullName must not return null");
        }
        return string;
    }

    @Nullable
    public String getTrackedRemoteName(Project project, VirtualFile root) throws VcsException {
        return GitConfigUtil.getValue(project, root, this.trackedRemoteKey());
    }

    @Nullable
    public String getTrackedBranchName(Project project, VirtualFile root) throws VcsException {
        return GitConfigUtil.getValue(project, root, this.trackedBranchKey());
    }

    public static void list(Project project, VirtualFile root, boolean local, boolean remote, Collection<GitBranch> branches) throws VcsException {
        ArrayList<String> temp = new ArrayList<String>();
        if (local) {
            GitBranch.listAsStrings(project, root, false, true, temp);
            for (String b : temp) {
                branches.add(new GitBranch(b, false, false));
            }
            temp.clear();
        }
        if (remote) {
            GitBranch.listAsStrings(project, root, true, false, temp);
            for (String b : temp) {
                branches.add(new GitBranch(b, false, true));
            }
        }
    }

    public void setTrackedBranch(Project project, VirtualFile root, String remote, String branch) throws VcsException {
        if (remote == null || branch == null) {
            GitConfigUtil.unsetValue(project, root, this.trackedRemoteKey());
            GitConfigUtil.unsetValue(project, root, this.trackedBranchKey());
        } else {
            GitConfigUtil.setValue(project, root, this.trackedRemoteKey(), remote);
            GitConfigUtil.setValue(project, root, this.trackedBranchKey(), branch);
        }
    }

    private String trackedBranchKey() {
        return "branch." + this.getName() + ".merge";
    }

    private String trackedRemoteKey() {
        return "branch." + this.getName() + ".remote";
    }

    @Nullable
    public GitBranch tracked(Project project, VirtualFile root) throws VcsException {
        boolean remoteFlag;
        String remote = this.getTrackedRemoteName(project, root);
        if (remote == null) {
            return null;
        }
        String branch = this.getTrackedBranchName(project, root);
        if (branch == null) {
            return null;
        }
        if (branch.startsWith(REFS_HEADS_PREFIX)) {
            branch = branch.substring(REFS_HEADS_PREFIX.length());
        }
        if (!".".equals(remote)) {
            branch = remote + "/" + branch;
            remoteFlag = true;
        } else {
            remoteFlag = false;
        }
        return new GitBranch(branch, false, remoteFlag);
    }

    @Nullable
    public GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitBranch branch) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitBranch.getMergeBase must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitBranch.getMergeBase must not be null");
        }
        if (branch == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/GitBranch.getMergeBase must not be null");
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.MERGE_BASE);
        h.setNoSSH(true);
        h.setSilent(true);
        h.addParameters(this.getFullName(), branch.getFullName());
        String output = h.run().trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }
}

