/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.quickedit;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.intelliLang.inject.quickedit.QuickEditEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickEditAction
implements IntentionAction {
    private String myLastLanguageName;

    @NotNull
    public String getText() {
        String string = "Edit " + StringUtil.notNullize((String)this.myLastLanguageName, (String)"Injected") + " Fragment";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/quickedit/QuickEditAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Edit Injected Fragment" == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/quickedit/QuickEditAction.getFamilyName must not return null");
        }
        return "Edit Injected Fragment";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/quickedit/QuickEditAction.isAvailable must not be null");
        }
        return this.getRangePair(file, editor.getCaretModel().getOffset()) != null;
    }

    @Nullable
    private Pair<PsiElement, TextRange> getRangePair(PsiFile file, int offset) {
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiLanguageInjectionHost.class, (boolean)false);
        if (host == null) {
            return null;
        }
        List injections = InjectedLanguageUtil.getInjectedPsiFiles((PsiElement)host);
        if (injections == null || injections.isEmpty()) {
            return null;
        }
        final int offsetInElement = offset - host.getTextRange().getStartOffset();
        Pair rangePair = (Pair)ContainerUtil.find((Iterable)injections, (Condition)new Condition<Pair<PsiElement, TextRange>>(){

            public boolean value(Pair<PsiElement, TextRange> pair) {
                return ((TextRange)pair.second).containsRange(offsetInElement, offsetInElement);
            }
        });
        if (rangePair != null) {
            this.myLastLanguageName = ((PsiElement)rangePair.first).getContainingFile().getLanguage().getDisplayName();
        }
        return rangePair;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/quickedit/QuickEditAction.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        Pair<PsiElement, TextRange> pair = this.getRangePair(file, offset);
        assert (pair != null);
        PsiFile injectedFile = (PsiFile)pair.first;
        final Place shreds = InjectedLanguageUtil.getShreds((PsiFile)injectedFile);
        FileType fileType = injectedFile.getFileType();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        String text = InjectedLanguageManager.getInstance((Project)project).getUnescapedText((PsiElement)injectedFile);
        PsiFile file2 = factory.createFileFromText("dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        file2.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, (Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)file));
        final Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        assert (document != null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(document, new ReadonlyFragmentModificationHandler(){

            public void handle(ReadOnlyFragmentModificationException e) {
            }
        });
        HashMap markers = ContainerUtil.assignValues((Iterator)shreds.iterator(), (Convertor)new Convertor<PsiLanguageInjectionHost.Shred, RangeMarker>(){

            public RangeMarker convert(PsiLanguageInjectionHost.Shred shred) {
                return document.createRangeMarker(shred.range.getStartOffset() + shred.prefix.length(), shred.range.getEndOffset() - shred.suffix.length());
            }
        });
        boolean first = true;
        for (PsiLanguageInjectionHost.Shred shred : shreds) {
            RangeMarker marker = (RangeMarker)markers.get(shred);
            if (first) {
                marker.setGreedyToLeft(true);
            }
            marker.setGreedyToRight(true);
            first = false;
        }
        int curOffset = 0;
        for (PsiLanguageInjectionHost.Shred shred : shreds) {
            RangeMarker marker = (RangeMarker)markers.get(shred);
            int start = marker.getStartOffset();
            int end = marker.getEndOffset();
            if (curOffset < start) {
                RangeMarker rangeMarker = document.createGuardedBlock(curOffset, start);
                if (curOffset == 0) {
                    rangeMarker.setGreedyToLeft(true);
                }
            }
            curOffset = end;
        }
        if (curOffset < text.length()) {
            document.createGuardedBlock(curOffset, text.length()).setGreedyToRight(true);
        }
        final QuickEditEditor e = new QuickEditEditor(document, project, fileType, new QuickEditEditor.QuickEditSaver((Map)markers){
            final /* synthetic */ Map val$markers;
            {
                this.val$markers = map;
            }

            @Override
            public void save(String text) {
                Map map = ContainerUtil.classify((Iterator)shreds.iterator(), (Convertor)new Convertor<PsiLanguageInjectionHost.Shred, PsiLanguageInjectionHost>(){

                    public PsiLanguageInjectionHost convert(PsiLanguageInjectionHost.Shred o) {
                        return o.host;
                    }
                });
                for (PsiLanguageInjectionHost host : map.keySet()) {
                    String hostText = host.getText();
                    TextRange insideHost = null;
                    StringBuilder sb = new StringBuilder();
                    for (PsiLanguageInjectionHost.Shred shred : (Set)map.get(host)) {
                        TextRange localInsideHost = shred.getRangeInsideHost();
                        TextRange localInsideFile = new TextRange(((RangeMarker)this.val$markers.get(shred)).getStartOffset(), ((RangeMarker)this.val$markers.get(shred)).getEndOffset());
                        if (insideHost != null) {
                            sb.append(hostText.substring(insideHost.getEndOffset(), localInsideHost.getStartOffset()));
                        }
                        sb.append(localInsideFile.substring(text));
                        insideHost = insideHost == null ? localInsideHost : insideHost.union(localInsideHost);
                    }
                    assert (insideHost != null);
                    ElementManipulators.getManipulator((PsiElement)host).handleContentChange((PsiElement)host, insideHost, sb.toString());
                }
            }
        });
        if (!shreds.isEmpty()) {
            int start = ((RangeMarker)markers.get(shreds.get(0))).getStartOffset();
            e.getEditor().getCaretModel().moveToOffset(start);
            e.getEditor().getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(e.getComponent(), e.getPreferredFocusedComponent());
        builder.setMovable(true);
        builder.setResizable(true);
        builder.setRequestFocus(true);
        builder.setTitle("<html>Edit <b>" + fileType.getName() + "</b> Fragment</html>");
        builder.setAdText("Press Ctrl+Enter to save, Escape to cancel.");
        builder.setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                e.setCancel(true);
                try {
                    e.uninstall();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Boolean.TRUE;
            }
        });
        builder.setModalContext(true);
        builder.setDimensionServiceKey(project, this.getClass().getSimpleName() + "DimensionKey", false);
        JBPopup popup = builder.createPopup();
        e.install(popup);
        popup.showCenteredInCurrentWindow(project);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

