/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;

public final class DefaultLanguageInjector
implements MultiHostInjector {
    private final Configuration myInjectionConfiguration;

    public DefaultLanguageInjector(Configuration configuration) {
        this.myInjectionConfiguration = configuration;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiLanguageInjectionHost>> list = Collections.singletonList(PsiLanguageInjectionHost.class);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/DefaultLanguageInjector.elementsToInjectIn must not return null");
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/DefaultLanguageInjector.getLanguagesToInject must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/DefaultLanguageInjector.getLanguagesToInject must not be null");
        }
        Set<String> allIds = this.myInjectionConfiguration.getAllInjectorIds();
        block0: for (LanguageInjectionSupport support : (LanguageInjectionSupport[])Extensions.getExtensions(LanguageInjectionSupport.EP_NAME)) {
            if (!allIds.contains(support.getId()) || !support.useDefaultInjector(host)) continue;
            for (BaseInjection injection : this.myInjectionConfiguration.getInjections(support.getId())) {
                Language language;
                if (!injection.acceptsPsiElement(host) || (language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId())) == null) continue;
                InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
                ArrayList<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list = new ArrayList<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>();
                for (TextRange range : injection.getInjectedArea(host)) {
                    list.add((Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>)Trinity.create((Object)((PsiLanguageInjectionHost)host), (Object)injectedLanguage, (Object)range));
                }
                InjectorUtils.registerInjection(language, list, host.getContainingFile(), registrar);
                continue block0;
            }
        }
    }
}

