/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.refactoring.GroovyChangeContextUtil;

public class MoveGroovyMemberHandler
implements MoveMemberHandler {
    public MoveMembersProcessor.MoveMembersUsageInfo getUsage(PsiMember member, PsiReference psiReference, Set<PsiMember> membersToMove, PsiClass targetClass) {
        PsiElement ref = psiReference.getElement();
        if (ref instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)ref;
            GrExpression qualifier = refExpr.getQualifierExpression();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refExpr, membersToMove, (PsiClass)targetClass, (boolean)true)) {
                if (!this.isInMovedElement(refExpr, membersToMove) ? qualifier != null : qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).isReferenceTo((PsiElement)member.getContainingClass())) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, null, (PsiElement)qualifier, psiReference);
                }
            } else {
                if (qualifier == null) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)refExpr, psiReference);
                }
                return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
            }
        }
        return null;
    }

    private boolean isInMovedElement(PsiElement element, Set<PsiMember> membersToMove) {
        for (PsiMember member : membersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean changeExternalUsage(MoveMembersOptions options, MoveMembersProcessor.MoveMembersUsageInfo usage) {
        if (!usage.getElement().isValid()) {
            return true;
        }
        if (usage.reference instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)usage.reference;
            GrExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier != null) {
                if (usage.qualifierClass != null) {
                    this.changeQualifier(refExpr, usage.qualifierClass);
                } else {
                    refExpr.setQualifierExpression(null);
                }
            } else if (usage.qualifierClass != null) {
                this.changeQualifier(refExpr, usage.qualifierClass);
            }
            return true;
        }
        return false;
    }

    public PsiMember doMove(MoveMembersOptions options, PsiMember member, PsiElement anchor, PsiClass targetClass) {
        PsiMember memberCopy;
        GroovyChangeContextUtil.encodeContextInfo((PsiElement)member);
        if (options.makeEnumConstant() && member instanceof PsiVariable && EnumConstantsUtil.isSuitableForEnumConstant((PsiType)((PsiVariable)member).getType(), (PsiClass)targetClass)) {
            memberCopy = MoveGroovyMemberHandler.createEnumConstant(member.getName(), ((GrVariable)member).getInitializerGroovy(), member.getProject());
            member.delete();
            memberCopy = (PsiMember)MoveGroovyMemberHandler.addEnumConstant(targetClass, (GrEnumConstant)memberCopy, anchor);
        } else if (member instanceof GrEnumConstant) {
            memberCopy = (PsiMember)member.copy();
            member.delete();
            memberCopy = (PsiMember)MoveGroovyMemberHandler.addEnumConstant(targetClass, (GrEnumConstant)memberCopy, null);
        } else {
            if (member instanceof GrField) {
                int i;
                GrVariableDeclaration parent = (GrVariableDeclaration)member.getParent();
                int number = this.findMemberNumber(parent.getMembers(), (GrField)member);
                GrVariableDeclaration parentCopy = (GrVariableDeclaration)parent.copy();
                GrMember[] members = parentCopy.getMembers();
                for (i = 0; i < number; ++i) {
                    members[i].delete();
                }
                for (i = number + 1; i < members.length; ++i) {
                    members[i].delete();
                }
                GrMember memberCopy2 = parentCopy.getMembers()[0];
                if (member.getContainingClass().isInterface() && !targetClass.isInterface()) {
                    PsiModifierList list = memberCopy2.getModifierList();
                    assert (list != null);
                    VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
                    list.setModifierProperty("static", member.hasModifierProperty("static"));
                    list.setModifierProperty("final", member.hasModifierProperty("final"));
                }
                member.delete();
                if (anchor != null) {
                    anchor = anchor.getParent();
                }
                parentCopy = (GrVariableDeclaration)targetClass.addAfter((PsiElement)parentCopy, anchor);
                return parentCopy.getMembers()[0];
            }
            if (member instanceof GrMethod) {
                memberCopy = (PsiMember)member.copy();
                if (member.getContainingClass().isInterface() && !targetClass.isInterface()) {
                    PsiModifierList list = memberCopy.getModifierList();
                    assert (list != null);
                    list.setModifierProperty("static", member.hasModifierProperty("static"));
                    list.setModifierProperty("final", member.hasModifierProperty("final"));
                    VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
                }
                member.delete();
                memberCopy = (PsiMember)targetClass.addAfter((PsiElement)memberCopy, anchor);
            } else {
                memberCopy = (PsiMember)member.copy();
                member.delete();
                memberCopy = (PsiMember)targetClass.addAfter((PsiElement)memberCopy, anchor);
            }
        }
        return memberCopy;
    }

    public void decodeContextInfo(PsiElement scope) {
        GroovyChangeContextUtil.decodeContextInfo(scope, null, null);
    }

    private int findMemberNumber(PsiMember[] members, GrMember member) {
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].equals(member)) continue;
            return i;
        }
        return -1;
    }

    private void changeQualifier(GrReferenceExpression refExpr, PsiClass aClass) throws IncorrectOperationException {
        if (MoveGroovyMemberHandler.hasOnDemandStaticImport(refExpr, aClass)) {
            refExpr.setQualifierExpression(null);
        } else {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(refExpr.getProject());
            refExpr.setQualifierExpression(factory.createReferenceExpressionFromText(aClass.getName()));
            ((GrReferenceExpression)refExpr.getQualifierExpression()).bindToElement((PsiElement)aClass);
        }
    }

    public static boolean hasOnDemandStaticImport(PsiElement element, PsiClass aClass) {
        if (element.getContainingFile() instanceof GroovyFile) {
            GrImportStatement[] importStatements;
            for (GrImportStatement stmt : importStatements = ((GroovyFile)element.getContainingFile()).getImportStatements()) {
                GrCodeReferenceElement ref = stmt.getImportReference();
                if (ref == null || !stmt.isStatic() || !stmt.isOnDemand() || ref.resolve() != aClass) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public PsiElement getAnchor(PsiMember member, final PsiClass targetClass) {
        if (member instanceof GrField && member.hasModifierProperty("static")) {
            final ArrayList referencedFields = new ArrayList();
            GrExpression psiExpression = ((GrField)member).getInitializerGroovy();
            if (psiExpression != null) {
                psiExpression.accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitReferenceExpression(GrReferenceExpression expression) {
                        GrField grField;
                        super.visitReferenceExpression(expression);
                        PsiElement psiElement = expression.resolve();
                        if (psiElement instanceof GrField && (grField = (GrField)psiElement).getContainingClass() == targetClass && !referencedFields.contains(grField)) {
                            referencedFields.add(grField);
                        }
                    }
                });
            }
            if (!referencedFields.isEmpty()) {
                Collections.sort(referencedFields, new Comparator<PsiField>(){

                    @Override
                    public int compare(PsiField o1, PsiField o2) {
                        return -PsiUtilBase.compareElementsByPosition((PsiElement)o1, (PsiElement)o2);
                    }
                });
                return (PsiElement)referencedFields.get(0);
            }
        }
        return null;
    }

    private static GrEnumConstant createEnumConstant(String constantName, GrExpression initializerExpr, Project project) throws IncorrectOperationException {
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(project);
        String enumConstantText = initializerExpr != null ? constantName + "(" + initializerExpr.getText() + ")" : constantName;
        return elementFactory.createEnumConstantFromText(enumConstantText);
    }

    private static PsiElement addEnumConstant(PsiClass targetClass, GrEnumConstant constant, PsiElement anchor) {
        if (targetClass instanceof GrEnumTypeDefinition) {
            GrEnumTypeDefinition enumeration = (GrEnumTypeDefinition)targetClass;
            GrEnumConstantList constantList = enumeration.getEnumConstantList();
            if (constantList != null) {
                ASTNode node = constantList.getNode();
                node.addLeaf(GroovyElementTypes.mCOMMA, (CharSequence)",", node.getFirstChildNode());
                return constantList.addBefore(constant, constantList.getFirstChild());
            }
            PsiElement parent = constant.getParent();
            assert (parent instanceof GrEnumConstantList);
            GrEnumConstantList constListCopy = (GrEnumConstantList)targetClass.add(parent);
            return constListCopy.getEnumConstants()[0];
        }
        return anchor != null ? targetClass.addAfter((PsiElement)constant, anchor) : targetClass.add((PsiElement)constant);
    }
}

