/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ParameterInfo;

public class ExtractMethodInfoHelper {
    private final Map<String, ParameterInfo> myInputNamesMap = new HashMap<String, ParameterInfo>();
    private final String myOutputName;
    private final PsiType myOutputType;
    private final GrMemberOwner myTargetClass;
    private final boolean myIsStatic;
    private final boolean myIsReturnStatement;
    private boolean mySpecifyType;
    private final PsiElement[] myInnerElements;
    private String myVisibility;
    private final Project myProject;
    private final GrStatement[] myStatements;

    public ExtractMethodInfoHelper(VariableInfo[] inputInfos, VariableInfo outputInfo, PsiElement[] innerElements, GrStatement[] statements, GrMemberOwner targetClass, boolean isStatic, boolean isReturnStatement) {
        PsiType type;
        this.myInnerElements = innerElements;
        this.myStatements = statements;
        this.myTargetClass = targetClass;
        this.myIsStatic = isStatic;
        this.myIsReturnStatement = isReturnStatement;
        this.myVisibility = "private";
        assert (this.myStatements.length > 0);
        this.myProject = this.myStatements[0].getProject();
        int i = 0;
        for (VariableInfo info : inputInfos) {
            PsiType type2 = info.getType();
            ParameterInfo pInfo = new ParameterInfo(info.getName(), i, type2);
            this.myInputNamesMap.put(info.getName(), pInfo);
            ++i;
        }
        if (outputInfo != null) {
            this.myOutputName = outputInfo.getName();
            type = outputInfo.getType();
            this.myOutputType = type == null ? PsiType.VOID : type;
        } else {
            PsiType returnType;
            this.myOutputName = null;
            this.myOutputType = ExtractMethodUtil.isSingleExpression(statements) || statements.length == 1 && statements[0] instanceof GrExpression && !(statements[0] instanceof GrAssignmentExpression) ? ((type = ((GrExpression)statements[0]).getType()) != null ? TypeConversionUtil.erasure((PsiType)type) : PsiType.VOID) : ((returnType = this.referTypeFromContext(this.myStatements)) == null ? PsiType.VOID : returnType);
        }
        this.mySpecifyType = !PsiType.VOID.equals(this.myOutputType) && !this.myOutputType.equalsToText("java.lang.Object");
    }

    private PsiType referTypeFromContext(GrStatement[] statements) {
        assert (statements.length > 0);
        GrStatement finalStatement = statements[statements.length - 1];
        if (finalStatement instanceof GrExpression) {
            GrExpression expr = (GrExpression)finalStatement;
            PsiElement parent = expr.getParent();
            GrStatement[] grStatements = GrStatement.EMPTY_ARRAY;
            if (parent instanceof GrClosableBlock) {
                grStatements = ((GrClosableBlock)parent).getStatements();
            } else if (parent instanceof GrOpenBlock && parent.getParent() instanceof GrMethod) {
                grStatements = ((GrOpenBlock)parent).getStatements();
            }
            if (grStatements.length > 0 && grStatements[grStatements.length - 1] == expr) {
                PsiType type = expr.getType();
                if (type != null) {
                    type = TypeConversionUtil.erasure((PsiType)type);
                }
                return type;
            }
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodInfoHelper.getProject must not return null");
        }
        return project;
    }

    public ParameterInfo[] getParameterInfos() {
        Collection<ParameterInfo> collection = this.myInputNamesMap.values();
        ParameterInfo[] infos = new ParameterInfo[collection.size()];
        for (ParameterInfo info : collection) {
            int position = info.getPosition();
            assert (position < infos.length && infos[position] == null);
            infos[position] = info;
        }
        return infos;
    }

    public boolean setNewName(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodInfoHelper.setNewName must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodInfoHelper.setNewName must not be null");
        }
        ParameterInfo info = this.myInputNamesMap.remove(oldName);
        if (info == null) {
            return false;
        }
        info.setNewName(newName);
        this.myInputNamesMap.put(newName, info);
        return true;
    }

    @Nullable
    public String getOutputName() {
        return this.myOutputName;
    }

    public String[] getArgumentNames() {
        Collection<ParameterInfo> infos = this.myInputNamesMap.values();
        String[] argNames = new String[infos.size()];
        for (ParameterInfo info : infos) {
            int position = info.getPosition();
            assert (position < argNames.length);
            argNames[position] = info.passAsParameter() ? info.getOldName() : "";
        }
        return argNames;
    }

    @NotNull
    public PsiType getOutputType() {
        PsiType psiType = this.myOutputType;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodInfoHelper.getOutputType must not return null");
        }
        return psiType;
    }

    @NotNull
    public PsiElement[] getInnerElements() {
        if (this.myInnerElements == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodInfoHelper.getInnerElements must not return null");
        }
        return this.myInnerElements;
    }

    @NotNull
    public GrStatement[] getStatements() {
        if (this.myStatements == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodInfoHelper.getStatements must not return null");
        }
        return this.myStatements;
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    public String getVisibility() {
        return this.myVisibility;
    }

    public void setVisibility(String visibility) {
        this.myVisibility = visibility;
    }

    public boolean specifyType() {
        return this.mySpecifyType;
    }

    public void setSpecifyType(boolean specifyType) {
        this.mySpecifyType = specifyType;
    }

    @NotNull
    public GrMemberOwner getOwner() {
        GrMemberOwner grMemberOwner = this.myTargetClass;
        if (grMemberOwner == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/ExtractMethodInfoHelper.getOwner must not return null");
        }
        return grMemberOwner;
    }

    public boolean isReturnStatement() {
        return this.myIsReturnStatement;
    }
}

