/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith.surrounders.surroundersImpl.blocks.open;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.surroundWith.surrounders.GroovyManyStatementsSurrounder;

public class GroovyWithIfSurrounder
extends GroovyManyStatementsSurrounder {
    @Override
    protected GroovyPsiElement doSurroundElements(PsiElement[] elements) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(elements[0].getProject());
        GrIfStatement ifStatement = (GrIfStatement)factory.createTopElementFromText("if (a) {\n}");
        this.addStatements(((GrBlockStatement)ifStatement.getThenBranch()).getBlock(), elements);
        return ifStatement;
    }

    @Override
    protected TextRange getSurroundSelectionRange(GroovyPsiElement element) {
        assert (element instanceof GrIfStatement);
        GrCondition condition = ((GrIfStatement)element).getCondition();
        int endOffset = element.getTextRange().getEndOffset();
        if (condition != null) {
            PsiElement child = condition.getFirstChild();
            assert (child != null);
            endOffset = child.getTextRange().getStartOffset();
            condition.getParent().getNode().removeChild(condition.getNode());
        }
        return new TextRange(endOffset, endOffset);
    }

    public String getTemplateDescription() {
        return "if () {...}";
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/surroundWith/surrounders/surroundersImpl/blocks/open/GroovyWithIfSurrounder.isApplicable must not be null");
        }
        if (!super.isApplicable(elements)) {
            return false;
        }
        if (elements.length == 1 && elements[0] instanceof GrStatement && elements[0] instanceof GrExpression) {
            PsiType type = ((GrExpression)elements[0]).getType();
            return type == null || !((PsiPrimitiveType)PsiType.BOOLEAN).getBoxedTypeName().equals(type.getCanonicalText());
        }
        return true;
    }
}

