/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.DominanceAwareMethod;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class MethodResolverProcessor
extends ResolverProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor");
    private final PsiType myThisType;
    @Nullable
    private PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private final Set<GroovyResolveResult> myInapplicableCandidates = new LinkedHashSet<GroovyResolveResult>();
    private final boolean myIsConstructor;
    private boolean myStopExecuting = false;

    public MethodResolverProcessor(String name, GroovyPsiElement place, boolean isConstructor, PsiType thisType, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments) {
        super(name, EnumSet.of(ClassHint.ResolveKind.METHOD, ClassHint.ResolveKind.PROPERTY), place, PsiType.EMPTY_ARRAY);
        this.myIsConstructor = isConstructor;
        this.myThisType = thisType;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        if (this.myStopExecuting) {
            return false;
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor() != this.myIsConstructor) {
                return true;
            }
            if (substitutor == null) {
                substitutor = PsiSubstitutor.EMPTY;
            }
            substitutor = this.obtainSubstitutor(substitutor, method);
            boolean isAccessible = this.isAccessible((PsiNamedElement)method);
            boolean isStaticsOK = this.isStaticsOK((PsiNamedElement)method);
            if (PsiUtil.isApplicable(this.myArgumentTypes, method, substitutor, this.myCurrentFileResolveContext instanceof GrMethodCallExpression, (GroovyPsiElement)this.myPlace)) {
                this.myCandidates.add(new GroovyResolveResultImpl((PsiElement)method, this.myCurrentFileResolveContext, substitutor, isAccessible, isStaticsOK));
            } else {
                this.myInapplicableCandidates.add(new GroovyResolveResultImpl((PsiElement)method, this.myCurrentFileResolveContext, substitutor, isAccessible, isStaticsOK));
            }
            return true;
        }
        return true;
    }

    private PsiSubstitutor obtainSubstitutor(PsiSubstitutor substitutor, PsiMethod method) {
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (this.myTypeArguments.length == typeParameters.length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters[i];
                PsiType typeArgument = this.myTypeArguments[i];
                substitutor = substitutor.put(typeParameter, typeArgument);
            }
            return substitutor;
        }
        if (this.argumentsSupplied() && method.hasTypeParameters()) {
            PsiType[] argTypes = this.myArgumentTypes;
            if (method instanceof GrGdkMethod) {
                assert (argTypes != null);
                PsiType[] newArgTypes = new PsiType[argTypes.length + 1];
                newArgTypes[0] = this.myThisType;
                System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
                argTypes = newArgTypes;
                method = ((GrGdkMethod)method).getStaticMethod();
                LOG.assertTrue(method.isValid());
            }
            return this.inferMethodTypeParameters(method, substitutor, typeParameters, argTypes);
        }
        return substitutor;
    }

    private PsiSubstitutor inferMethodTypeParameters(PsiMethod method, PsiSubstitutor partialSubstitutor, PsiTypeParameter[] typeParameters, PsiType[] argTypes) {
        if (typeParameters.length == 0) {
            return partialSubstitutor;
        }
        if (this.argumentsSupplied()) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            int max = Math.max(parameters.length, argTypes.length);
            PsiType[] parameterTypes = new PsiType[max];
            PsiType[] argumentTypes = new PsiType[max];
            for (int i = 0; i < parameterTypes.length; ++i) {
                PsiType paramType;
                parameterTypes[i] = paramType = MethodResolverProcessor.handleVarargs(argTypes, parameters, i);
                argumentTypes[i] = this.handleConversion(paramType, argTypes, i);
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
            PsiSubstitutor substitutor = helper.inferTypeArguments(typeParameters, parameterTypes, argumentTypes, LanguageLevel.HIGHEST);
            for (PsiTypeParameter typeParameter : typeParameters) {
                if (substitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
                substitutor = this.inferFromContext(typeParameter, method.getReturnType(), substitutor, helper);
            }
            return partialSubstitutor.putAll(substitutor);
        }
        return partialSubstitutor;
    }

    private PsiType handleConversion(PsiType paramType, PsiType[] argTypes, int i) {
        if (i < argTypes.length) {
            PsiType argType = argTypes[i];
            GroovyPsiElement context = (GroovyPsiElement)this.myPlace;
            if (!TypesUtil.isAssignable(TypeConversionUtil.erasure((PsiType)paramType), argType, context.getManager(), context.getResolveScope(), false) && TypesUtil.isAssignableByMethodCallConversion(paramType, argType, context)) {
                return paramType;
            }
            return argType;
        }
        return PsiType.NULL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiType handleVarargs(PsiType[] argTypes, PsiParameter[] parameters, int index) {
        PsiType psiType;
        if (index < parameters.length) {
            PsiType type = parameters[index].getType();
            if (!(argTypes.length == parameters.length && type instanceof PsiEllipsisType && !(argTypes[argTypes.length - 1] instanceof PsiArrayType) ? (psiType = ((PsiEllipsisType)type).getComponentType()) != null : (psiType = type) != null)) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor.handleVarargs must not return null");
            return psiType;
        }
        if (parameters.length > 0) {
            PsiType lastParameterType = parameters[parameters.length - 1].getType();
            if (!(argTypes.length > parameters.length && lastParameterType instanceof PsiEllipsisType ? (psiType = ((PsiEllipsisType)lastParameterType).getComponentType()) != null : (psiType = lastParameterType) != null)) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor.handleVarargs must not return null");
            return psiType;
        }
        psiType = PsiType.NULL;
        if (psiType != null) return psiType;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor.handleVarargs must not return null");
    }

    private PsiSubstitutor inferFromContext(PsiTypeParameter typeParameter, PsiType lType, PsiSubstitutor substitutor, PsiResolveHelper helper) {
        PsiType inferred;
        if (this.myPlace != null && (inferred = helper.getSubstitutionForTypeParameter(typeParameter, lType, this.getContextType(), false, LanguageLevel.HIGHEST)) != PsiType.NULL) {
            return substitutor.put(typeParameter, inferred);
        }
        return substitutor;
    }

    @Nullable
    private PsiType getContextType() {
        PsiElement parent = this.myPlace.getParent().getParent();
        PsiType rType = null;
        if (parent instanceof GrReturnStatement) {
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, GrMethod.class);
            if (method != null) {
                rType = method.getDeclaredReturnType();
            }
        } else if (parent instanceof GrAssignmentExpression && this.myPlace.equals(((GrAssignmentExpression)parent).getRValue())) {
            rType = ((GrAssignmentExpression)parent).getLValue().getType();
        } else if (parent instanceof GrVariable) {
            rType = ((GrVariable)parent).getDeclaredType();
        }
        return rType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        GroovyResolveResult[] groovyResolveResultArray;
        if (!this.myCandidates.isEmpty()) {
            groovyResolveResultArray = this.filterCandidates();
            if (groovyResolveResultArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor.getCandidates must not return null");
            return groovyResolveResultArray;
        }
        if (!this.myInapplicableCandidates.isEmpty()) {
            groovyResolveResultArray = ResolveUtil.filterSameSignatureCandidates(this.myInapplicableCandidates, this.myArgumentTypes != null ? this.myArgumentTypes.length : -1);
            if (groovyResolveResultArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor.getCandidates must not return null");
            return groovyResolveResultArray;
        }
        groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
        if (GroovyResolveResult.EMPTY_ARRAY != null) return groovyResolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor.getCandidates must not return null");
    }

    private GroovyResolveResult[] filterCandidates() {
        GroovyResolveResult[] array = this.myCandidates.toArray(new GroovyResolveResult[this.myCandidates.size()]);
        if (array.length == 1) {
            return array;
        }
        ArrayList<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>();
        result.add(array[0]);
        PsiManager manager = this.myPlace.getManager();
        GlobalSearchScope scope = this.myPlace.getResolveScope();
        block0: for (int i = 1; i < array.length; ++i) {
            PsiElement currentElement = array[i].getElement();
            if (currentElement instanceof PsiMethod) {
                PsiMethod currentMethod = (PsiMethod)currentElement;
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    GroovyResolveResult otherResolveResult = (GroovyResolveResult)iterator.next();
                    PsiElement element = otherResolveResult.getElement();
                    if (!(element instanceof PsiMethod)) continue;
                    PsiMethod method = (PsiMethod)element;
                    if (this.dominated(currentMethod, array[i].getSubstitutor(), method, otherResolveResult.getSubstitutor(), manager, scope)) continue block0;
                    if (!this.dominated(method, otherResolveResult.getSubstitutor(), currentMethod, array[i].getSubstitutor(), manager, scope)) continue;
                    iterator.remove();
                }
            }
            result.add(array[i]);
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    private boolean dominated(PsiMethod method1, PsiSubstitutor substitutor1, PsiMethod method2, PsiSubstitutor substitutor2, PsiManager manager, GlobalSearchScope scope) {
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        if (method2 instanceof DominanceAwareMethod && ((DominanceAwareMethod)method2).isMoreConcreteThan(substitutor2, method1, substitutor1, (GroovyPsiElement)this.myPlace)) {
            return true;
        }
        if (method1 instanceof GrGdkMethod && method2 instanceof GrGdkMethod) {
            method1 = ((GrGdkMethod)method1).getStaticMethod();
            method2 = ((GrGdkMethod)method2).getStaticMethod();
        }
        if (this.myIsConstructor && this.myArgumentTypes != null && this.myArgumentTypes.length == 1) {
            if (method1.getParameterList().getParametersCount() == 0) {
                return true;
            }
            if (method2.getParameterList().getParametersCount() == 0) {
                return false;
            }
        }
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        if (this.myArgumentTypes == null && params1.length != params2.length) {
            return false;
        }
        if (params1.length < params2.length) {
            if (params1.length == 0) {
                return false;
            }
            PsiType lastType = params1[params1.length - 1].getType();
            return lastType instanceof PsiArrayType;
        }
        for (int i = 0; i < params2.length; ++i) {
            boolean converts2;
            boolean converts1;
            PsiType argType;
            PsiType type1 = substitutor1.substitute(params1[i].getType());
            PsiType type2 = substitutor2.substitute(params2[i].getType());
            if (this.myArgumentTypes != null && this.myArgumentTypes.length > i && (argType = this.myArgumentTypes[i]) != null && (converts1 = TypesUtil.isAssignable(type1, argType, manager, scope, false)) != (converts2 = TypesUtil.isAssignable(type2, argType, manager, scope, false))) {
                return converts2;
            }
            if (this.typesAgree(manager, scope, type1, type2)) continue;
            return false;
        }
        return true;
    }

    private boolean typesAgree(PsiManager manager, GlobalSearchScope scope, PsiType type1, PsiType type2) {
        if (this.argumentsSupplied() && type1 instanceof PsiArrayType && !(type2 instanceof PsiArrayType)) {
            type1 = ((PsiArrayType)type1).getComponentType();
        }
        return this.argumentsSupplied() ? TypesUtil.isAssignable(type1, type2, manager, scope) : type1.equals(type2);
    }

    private boolean argumentsSupplied() {
        return this.myArgumentTypes != null;
    }

    @Override
    public boolean hasCandidates() {
        return super.hasCandidates() || !this.myInapplicableCandidates.isEmpty();
    }

    public boolean hasApplicableCandidates() {
        return !this.myCandidates.isEmpty();
    }

    @Nullable
    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        super.handleEvent(event, associated);
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && this.myCandidates.size() > 0) {
            this.myStopExecuting = true;
        }
    }
}

