/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;

public class GrStringUtil {
    private static final String TRIPLE_QUOTES = "'''";
    private static final String QUOTE = "'";
    private static final String DOUBLE_QUOTES = "\"";
    private static final String TRIPLE_DOUBLE_QUOTES = "\"\"\"";
    public static final String GROOVY_LANG_GSTRING = "groovy.lang.GString";

    private GrStringUtil() {
    }

    public static String escapeSymbolsForGString(String s, boolean escapeDoubleQuotes) {
        int i;
        StringBuilder b = new StringBuilder();
        char[] chars = s.toCharArray();
        int len = chars.length - 1;
        for (i = 0; i < len; ++i) {
            if (chars[i] == '\\') {
                char next = chars[i + 1];
                if (next == '\'') {
                    b.append('\'');
                    ++i;
                    continue;
                }
                if (next == 'n') {
                    b.append('\n');
                    ++i;
                    continue;
                }
                if (escapeDoubleQuotes && next == '\"') {
                    b.append('\"');
                    ++i;
                    continue;
                }
                b.append(chars[i]);
                b.append(chars[++i]);
                continue;
            }
            if (chars[i] == '\"' || chars[i] == '$') {
                b.append('\\');
            }
            b.append(chars[i]);
        }
        if (i == len) {
            if (chars[i] == '\"') {
                b.append('\\');
            }
            b.append(chars[i]);
        }
        return b.toString();
    }

    public static String escapeSymbolsForString(String s, boolean escapeQuotes) {
        int i;
        StringBuilder b = new StringBuilder();
        char[] chars = s.toCharArray();
        int len = chars.length - 1;
        for (i = 0; i < len; ++i) {
            if (chars[i] == '\\') {
                char next = chars[i + 1];
                if (next == '\"' || next == '$') {
                    b.append(next);
                } else if (next == 'n') {
                    b.append('\n');
                } else if (escapeQuotes && next == '\'') {
                    b.append(next);
                } else {
                    b.append('\\');
                    b.append(next);
                }
                ++i;
                continue;
            }
            if (chars[i] == '\'') {
                b.append('\\');
            }
            b.append(chars[i]);
        }
        if (i == len) {
            if (chars[i] == '\'') {
                b.append('\\');
            }
            b.append(chars[i]);
        }
        return b.toString();
    }

    public static String removeQuotes(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GrStringUtil.removeQuotes must not be null");
        }
        if (s.startsWith(TRIPLE_QUOTES) || s.startsWith(TRIPLE_DOUBLE_QUOTES)) {
            if (s.endsWith(s.substring(0, 3))) {
                return s.substring(3, s.length() - 3);
            }
            return s.substring(3);
        }
        if (s.startsWith(QUOTE) || s.startsWith(DOUBLE_QUOTES)) {
            if (s.length() >= 2 && s.endsWith(s.substring(0, 1))) {
                return s.substring(1, s.length() - 1);
            }
            return s.substring(1);
        }
        return s;
    }

    public static String addQuotes(String s, boolean forGString) {
        if (forGString) {
            if (s.contains("\n")) {
                return TRIPLE_DOUBLE_QUOTES + s + TRIPLE_DOUBLE_QUOTES;
            }
            return DOUBLE_QUOTES + s + DOUBLE_QUOTES;
        }
        if (s.contains("\n")) {
            return TRIPLE_QUOTES + s + TRIPLE_QUOTES;
        }
        return QUOTE + s + QUOTE;
    }

    public static boolean isReplacedExpressionInGStringInjection(GrExpression replacedExpression) {
        PsiElement parent = replacedExpression.getParent();
        if (parent instanceof GrClosableBlock) {
            parent = parent.getParent();
        }
        return parent instanceof GrStringInjection;
    }

    public static GrString replaceStringInjectionByLiteral(PsiElement injection, GrLiteral literal) {
        String literalText;
        if (injection.getParent() instanceof GrClosableBlock) {
            injection = injection.getParent();
        }
        injection = injection.getParent();
        GrString grString = (GrString)injection.getParent();
        int injectionNumber = -1;
        for (PsiElement child : grString.getChildren()) {
            ++injectionNumber;
            if (child == injection) break;
        }
        if (injectionNumber == -1) {
            return grString;
        }
        GrString grStringWithBraces = GrStringUtil.addAllBracesInGString(grString);
        if (literal instanceof GrString) {
            literal = GrStringUtil.addAllBracesInGString((GrString)literal);
        }
        if ((literalText = GrStringUtil.escapeSymbolsForGString(GrStringUtil.removeQuotes(literal.getText()), false)).contains("\n")) {
            literalText = GrStringUtil.escapeSymbolsForGString(literalText, true);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(grString.getProject());
        GrExpression expression = factory.createExpressionFromText("\"${}" + literalText + DOUBLE_QUOTES);
        expression.getFirstChild().delete();
        expression.getFirstChild().delete();
        expression.getLastChild().delete();
        ASTNode node = grString.getNode();
        if (expression.getFirstChild() != null) {
            if (expression.getFirstChild() == expression.getLastChild()) {
                node.replaceChild(injection.getNode(), expression.getFirstChild().getNode());
            } else {
                node.addChildren(expression.getFirstChild().getNode(), expression.getLastChild().getNode(), injection.getNode());
                injection.delete();
            }
        }
        return grString;
    }

    public static GrString addAllBracesInGString(GrString grString) {
        StringBuilder newString = new StringBuilder();
        for (PsiElement child = grString.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof GrStringInjection && ((GrStringInjection)child).getReferenceExpression() != null) {
                GrReferenceExpression refExpr = ((GrStringInjection)child).getReferenceExpression();
                newString.append("${").append(refExpr != null ? refExpr.getText() : "").append('}');
                continue;
            }
            newString.append(child.getText());
        }
        return (GrString)GroovyPsiElementFactory.getInstance(grString.getProject()).createExpressionFromText(newString.toString());
    }

    public static boolean checkGStringInjectionForUnnecessaryBraces(PsiElement element) {
        GrExpression gString;
        if (!(element instanceof GrStringInjection)) {
            return false;
        }
        GrStringInjection injection = (GrStringInjection)element;
        GrClosableBlock block = injection.getClosableBlock();
        if (block == null) {
            return false;
        }
        GrStatement[] statements = block.getStatements();
        if (statements.length != 1) {
            return false;
        }
        if (!(statements[0] instanceof GrReferenceExpression)) {
            return false;
        }
        PsiElement next = injection.getNextSibling();
        if (!(next instanceof LeafPsiElement)) {
            return false;
        }
        char nextChar = next.getText().charAt(0);
        if (nextChar == '\"' || nextChar == '$') {
            return true;
        }
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(element.getProject());
        try {
            gString = elementFactory.createExpressionFromText("\"$" + statements[0].getText() + nextChar + '\"');
        }
        catch (Exception e) {
            return false;
        }
        if (!(gString instanceof GrString)) {
            return false;
        }
        PsiElement child = gString.getChildren()[0];
        if (!(child instanceof GrStringInjection)) {
            return false;
        }
        GrReferenceExpression refExprCopy = ((GrStringInjection)child).getReferenceExpression();
        if (!(refExprCopy instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)statements[0];
        return Comparing.equal((String)refExpr.getName(), (String)refExprCopy.getName());
    }

    public static void removeUnnecessaryBracesInGString(GrString grString) {
        for (PsiElement child : grString.getChildren()) {
            if (!GrStringUtil.checkGStringInjectionForUnnecessaryBraces(child)) continue;
            GrClosableBlock closableBlock = ((GrStringInjection)child).getClosableBlock();
            GrReferenceExpression refExpr = (GrReferenceExpression)closableBlock.getStatements()[0];
            GrReferenceExpression copy = (GrReferenceExpression)refExpr.copy();
            ASTNode oldNode = closableBlock.getNode();
            oldNode.getTreeParent().replaceChild(oldNode, copy.getNode());
        }
    }

    public static boolean isPlainString(@NotNull GrLiteral literal) {
        if (literal == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GrStringUtil.isPlainString must not be null");
        }
        return literal.getText().startsWith(QUOTE);
    }
}

