/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrParameterListImpl
extends GroovyPsiElementImpl
implements GrParameterList {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.statements.params.GrParameterListImpl");

    public GrParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterListImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitParameterList(this);
    }

    public String toString() {
        return "Parameter list";
    }

    @Override
    @NotNull
    public GrParameter[] getParameters() {
        GrParameter[] grParameterArray = (GrParameter[])this.findChildrenByClass(GrParameter.class);
        if (grParameterArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterListImpl.getParameters must not return null");
        }
        return grParameterArray;
    }

    public int getParameterIndex(PsiParameter parameter) {
        LOG.assertTrue(parameter.getParent() == this);
        return PsiImplUtil.getParameterIndex((PsiParameter)parameter, (PsiParameterList)this);
    }

    public int getParametersCount() {
        return this.getParameters().length;
    }

    @Override
    public void addParameterToEnd(GrParameter parameter) {
        GrParameter[] params = this.getParameters();
        ASTNode astNode = this.getNode();
        if (params.length == 0) {
            astNode.addChild(parameter.getNode());
        } else {
            GrParameter last = params[params.length - 1];
            astNode.addChild(parameter.getNode(), last.getNode());
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", last.getNode());
        }
    }

    @Override
    public void addParameterToHead(GrParameter parameter) {
        GrParameter[] params = this.getParameters();
        ASTNode astNode = this.getNode();
        ASTNode paramNode = parameter.getNode();
        assert (paramNode != null);
        if (params.length == 0) {
            astNode.addChild(paramNode);
        } else {
            GrParameter first = params[0];
            astNode.addChild(paramNode, first.getNode());
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", first.getNode());
        }
    }

    @Override
    public int getParameterNumber(GrParameter parameter) {
        for (int i = 0; i < this.getParameters().length; ++i) {
            GrParameter param = this.getParameters()[i];
            if (param != parameter) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Nullable
    public PsiElement removeParameter(GrParameter toRemove) {
        ASTNode astNode = this.getNode();
        for (GrParameter param : this.getParameters()) {
            ASTNode prev;
            if (param != toRemove) continue;
            ASTNode paramNode = param.getNode();
            assert (paramNode != null);
            PsiElement prevSibling = PsiUtil.getPrevNonSpace(param);
            astNode.removeChild(paramNode);
            if (prevSibling != null && (prev = prevSibling.getNode()) != null && prev.getElementType() == GroovyTokenTypes.mCOMMA) {
                astNode.removeChild(prev);
            }
            return toRemove;
        }
        return null;
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterListImpl.addAfter must not be null");
        }
        GrParameter[] params = this.getParameters();
        ASTNode astNode = this.getNode();
        if (params.length == 0) {
            astNode.addChild(element.getNode());
        } else {
            element = super.addAfter(element, anchor);
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", element.getNode());
        }
        CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat((PsiElement)this);
        return element;
    }
}

