/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;

public class GrBuiltinTypeClassExpressionImpl
extends GrExpressionImpl
implements GrBuiltinTypeClassExpression {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types.GrBuiltinTypeClassExpressionImpl");
    private static final Function<GrBuiltinTypeClassExpressionImpl, PsiType> TYPES_CALCULATOR = new MyTypesCalculator();

    public GrBuiltinTypeClassExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/types/GrBuiltinTypeClassExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitBuiltinTypeClassExpression(this);
    }

    public String toString() {
        return "builtin type class expression";
    }

    @Override
    public PsiType getType() {
        return GroovyPsiManager.getInstance(this.getProject()).getType(this, TYPES_CALCULATOR);
    }

    private static class MyTypesCalculator
    implements Function<GrBuiltinTypeClassExpressionImpl, PsiType> {
        private MyTypesCalculator() {
        }

        public PsiType fun(GrBuiltinTypeClassExpressionImpl expression) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
            PsiClass clazz = facade.findClass("java.lang.Class", expression.getResolveScope());
            if (clazz != null) {
                PsiElementFactory factory = facade.getElementFactory();
                PsiTypeParameter[] typeParameters = clazz.getTypeParameters();
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                if (typeParameters.length == 1) {
                    try {
                        PsiType type = factory.createTypeFromText(expression.getText(), null);
                        substitutor = substitutor.put(typeParameters[0], type);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                return factory.createType(clazz, substitutor);
            }
            return null;
        }
    }
}

