/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrReferenceExpressionImpl
extends GrReferenceElementImpl
implements GrReferenceExpression {
    private static final OurResolver RESOLVER = new OurResolver();
    private static final OurTypesCalculator TYPES_CALCULATOR = new OurTypesCalculator();

    public GrReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitReferenceExpression(this);
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode lastChild = this.getNode().getLastChildNode();
        if (lastChild == null) {
            return null;
        }
        for (IElementType elementType : TokenSets.REFERENCE_NAMES.getTypes()) {
            if (lastChild.getElementType() != elementType) continue;
            return lastChild.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        Object[] otherReferences = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, GrReferenceExpression.class);
        Object[] thisReference = new PsiReference[]{this};
        PsiMultiReference psiMultiReference = new PsiMultiReference((PsiReference[])(otherReferences.length == 0 ? thisReference : (PsiReference[])ArrayUtil.mergeArrays((Object[])thisReference, (Object[])otherReferences, PsiReference.class)), (PsiElement)this);
        if (psiMultiReference == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.getReference must not return null");
        }
        return psiMultiReference;
    }

    @Nullable
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            if (nameElement.getNode().getElementType() == GroovyElementTypes.mSTRING_LITERAL || nameElement.getNode().getElementType() == GroovyElementTypes.mGSTRING_LITERAL) {
                return GrStringUtil.removeQuotes(nameElement.getText());
            }
            return nameElement.getText();
        }
        return null;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMethod) {
            String newPropertyName;
            PsiMethod method = (PsiMethod)resolved;
            String oldName = this.getReferenceName();
            if (!method.getName().equals(oldName) && GroovyPropertyUtils.isSimplePropertyAccessor(method) && (newPropertyName = PropertyUtil.getPropertyName((String)newElementName)) != null) {
                return this.doHandleElementRename(newPropertyName);
            }
        } else if (resolved instanceof GrField && ((GrField)resolved).isProperty()) {
            GrField field = (GrField)resolved;
            String oldName = this.getReferenceName();
            if (oldName != null && !oldName.equals(field.getName())) {
                if (oldName.startsWith("get")) {
                    return this.doHandleElementRename("get" + StringUtil.capitalize((String)newElementName));
                }
                if (oldName.startsWith("set")) {
                    return this.doHandleElementRename("set" + StringUtil.capitalize((String)newElementName));
                }
            }
        }
        return this.doHandleElementRename(newElementName);
    }

    @Override
    protected PsiElement bindWithQualifiedRef(String qName) {
        GrTypeArgumentList list = this.getTypeArgumentList();
        String typeArgs = list != null ? list.getText() : "";
        String text = qName + typeArgs;
        GrReferenceExpression qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceExpressionFromText(text);
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        PsiUtil.shortenReference(qualifiedRef);
        return qualifiedRef;
    }

    private PsiElement doHandleElementRename(String newElementName) throws IncorrectOperationException {
        if (!PsiUtil.isValidReferenceName(newElementName)) {
            PsiElement element = GroovyPsiElementFactory.getInstance(this.getProject()).createStringLiteral(newElementName);
            this.getReferenceNameElement().replace(element);
            return this;
        }
        return super.handleElementRename(newElementName);
    }

    public int getTextOffset() {
        PsiElement parent = this.getParent();
        TextRange range = this.getTextRange();
        if (!(parent instanceof GrAssignmentExpression) || !this.equals(((GrAssignmentExpression)parent).getLValue())) {
            return range.getEndOffset();
        }
        return range.getStartOffset();
    }

    public String toString() {
        return "Reference expression";
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.getManager().getResolveCache().resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, true, false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @Override
    public PsiType getNominalType() {
        return GroovyPsiManager.getInstance(this.getProject()).getTypeInferenceHelper().doWithInferenceDisabled(new Computable<PsiType>(){

            @Nullable
            public PsiType compute() {
                return GrReferenceExpressionImpl.this.getNominalTypeImpl();
            }
        });
    }

    @Nullable
    private PsiType getNominalTypeImpl() {
        IElementType dotType = this.getDotTokenType();
        GroovyResolveResult resolveResult = this.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (dotType == GroovyTokenTypes.mMEMBER_POINTER) {
            if (resolved instanceof PsiMethod) {
                return GrClosureType.create((PsiMethod)resolved, resolveResult.getSubstitutor());
            }
            return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName("groovy.lang.Closure", this.getResolveScope());
        }
        PsiType result = null;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        if (resolved == null && !"class".equals(this.getReferenceName())) {
            resolved = this.getReference().resolve();
        }
        if (resolved instanceof PsiClass) {
            if (this.getParent() instanceof GrReferenceExpression) {
                result = facade.getElementFactory().createType((PsiClass)resolved);
            } else {
                PsiClass javaLangClass = facade.findClass("java.lang.Class", this.getResolveScope());
                if (javaLangClass != null) {
                    PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                    PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
                    if (typeParameters.length == 1) {
                        substitutor = substitutor.put(typeParameters[0], (PsiType)facade.getElementFactory().createType((PsiClass)resolved));
                    }
                    result = facade.getElementFactory().createType(javaLangClass, substitutor);
                }
            }
        } else if (resolved instanceof GrVariableBase) {
            result = ((GrVariableBase)resolved).getDeclaredType();
        } else if (resolved instanceof PsiVariable) {
            result = ((PsiVariable)resolved).getType();
        } else if (resolved instanceof PsiMethod && !GroovyPsiManager.isTypeBeingInferred(resolved)) {
            PsiClass containingClass;
            if (dotType == GroovyTokenTypes.mMEMBER_POINTER) {
                return facade.getElementFactory().createTypeByFQClassName("groovy.lang.Closure", this.getResolveScope());
            }
            PsiMethod method = (PsiMethod)resolved;
            result = PropertyUtil.isSimplePropertySetter((PsiMethod)method) && !method.getName().equals(this.getReferenceName()) ? method.getParameterList().getParameters()[0].getType() : ((containingClass = method.getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && "getClass".equals(method.getName()) ? this.getTypeForObjectGetClass(facade, method) : (method instanceof GrAccessorMethod ? ((GrAccessorMethod)method).getReturnTypeGroovy() : method.getReturnType()));
        } else if (resolved instanceof GrReferenceExpression) {
            PsiType rType;
            GrExpression rValue;
            GrAssignmentExpression assignment;
            PsiElement parent = resolved.getParent();
            if (parent instanceof GrAssignmentExpression && resolved.equals((assignment = (GrAssignmentExpression)parent).getLValue()) && (rValue = assignment.getRValue()) != null && (rType = rValue.getType()) != null) {
                result = rType;
            }
        } else if (resolved == null) {
            PsiSubstitutor substitutor;
            PsiClass mapClass;
            PsiClassType.ClassResolveResult qResult;
            PsiClass clazz;
            PsiType qType;
            if ("class".equals(this.getReferenceName())) {
                return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Class", this.getResolveScope());
            }
            GrExpression qualifier = this.getQualifierExpression();
            if (qualifier != null && (qType = qualifier.getType()) instanceof PsiClassType && (clazz = (qResult = ((PsiClassType)qType).resolveGenerics()).getElement()) != null && (mapClass = facade.findClass("java.util.Map", this.getResolveScope())) != null && mapClass.getTypeParameters().length == 2 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)mapClass, (PsiClass)clazz, (PsiSubstitutor)qResult.getSubstitutor())) != null) {
                return substitutor.substitute(mapClass.getTypeParameters()[1]);
            }
        }
        if (result != null) {
            result = resolveResult.getSubstitutor().substitute(result);
            result = TypesUtil.boxPrimitiveType(result, (PsiManager)this.getManager(), this.getResolveScope());
        }
        if (dotType != GroovyTokenTypes.mSPREAD_DOT) {
            return result;
        }
        return ResolveUtil.getListTypeForSpreadOperator(this, result);
    }

    @Nullable
    private PsiType getTypeForObjectGetClass(JavaPsiFacade facade, PsiMethod method) {
        PsiTypeParameter[] typeParameters;
        PsiClass clazz;
        PsiType type = method.getReturnType();
        if (type instanceof PsiClassType && (clazz = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(clazz.getQualifiedName()) && (typeParameters = clazz.getTypeParameters()).length == 1) {
            PsiClass qualifierClass = null;
            GrExpression qualifier = this.getQualifierExpression();
            if (qualifier != null) {
                PsiType qualifierType = qualifier.getType();
                if (qualifierType instanceof PsiClassType) {
                    qualifierClass = ((PsiClassType)qualifierType).resolve();
                }
            } else {
                PsiNamedElement context = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PsiClass.class, GroovyFile.class});
                if (context instanceof PsiClass) {
                    qualifierClass = (PsiClass)context;
                } else if (context instanceof GroovyFile) {
                    qualifierClass = ((GroovyFile)context).getScriptClass();
                }
            }
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (qualifierClass != null) {
                PsiClassType t = facade.getElementFactory().createType(qualifierClass);
                substitutor = substitutor.put(typeParameters[0], (PsiType)t);
            }
            return facade.getElementFactory().createType(clazz, substitutor);
        }
        return type;
    }

    @Override
    public PsiType getType() {
        return GroovyPsiManager.getInstance(this.getProject()).getType(this, TYPES_CALCULATOR);
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        if (newExpr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.replaceWithExpression must not be null");
        }
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    public String getName() {
        return this.getReferenceName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.setName must not be null");
        }
        PsiElement nameElement = this.getReferenceNameElement();
        ASTNode node = nameElement.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(name).getNode();
        assert (newNameNode != null && node != null);
        node.getTreeParent().replaceChild(node, newNameNode);
        return this;
    }

    private static PsiType getThisType(GrReferenceExpression refExpr) {
        PsiType qType;
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier != null && (qType = qualifier.getType()) != null) {
            return qType;
        }
        return TypesUtil.getJavaLangObject(refExpr);
    }

    Kind getKind() {
        if (this.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER) {
            return Kind.METHOD_OR_PROPERTY;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrMethodCallExpression || parent instanceof GrApplicationStatement) {
            return Kind.METHOD_OR_PROPERTY;
        }
        return Kind.TYPE_OR_PROPERTY;
    }

    @Nullable
    public String getCanonicalText() {
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)element)) {
            PsiElement target = this.resolve();
            if (element instanceof GrAccessorMethod && this.getManager().areElementsEquivalent((PsiElement)((GrAccessorMethod)element).getProperty(), target)) {
                return false;
            }
            return this.getManager().areElementsEquivalent(element, target);
        }
        if (element instanceof GrField && ((GrField)element).isProperty()) {
            PsiElement target = this.resolve();
            if (this.getManager().areElementsEquivalent(element, target)) {
                return true;
            }
            for (GrAccessorMethod getter : ((GrField)element).getGetters()) {
                if (!this.getManager().areElementsEquivalent((PsiElement)getter, target)) continue;
                return true;
            }
            return this.getManager().areElementsEquivalent((PsiElement)((GrField)element).getSetter(), target);
        }
        if (element instanceof PsiNamedElement && Comparing.equal((String)((PsiNamedElement)element).getName(), (String)this.getReferenceName())) {
            return this.getManager().areElementsEquivalent(element, this.resolve());
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public GrExpression getQualifierExpression() {
        return (GrExpression)this.findChildByClass(GrExpression.class);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifierExpression() != null;
    }

    @Override
    @Nullable
    public PsiElement getDotToken() {
        return this.findChildByType(GroovyTokenTypes.DOTS);
    }

    @Override
    public void replaceDotToken(PsiElement newDot) {
        if (newDot == null) {
            return;
        }
        if (!GroovyTokenTypes.DOTS.contains(newDot.getNode().getElementType())) {
            return;
        }
        PsiElement oldDot = this.getDotToken();
        if (oldDot == null) {
            return;
        }
        this.getNode().replaceChild(oldDot.getNode(), newDot.getNode());
    }

    @Override
    @Nullable
    public IElementType getDotTokenType() {
        PsiElement dot = this.getDotToken();
        return dot == null ? null : dot.getNode().getElementType();
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        ResolveResult[] results = this.getManager().getResolveCache().resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, false, false);
        return results.length == 1 ? (GroovyResolveResult)results[0] : GroovyResolveResult.EMPTY_RESULT;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incomplete) {
        GroovyResolveResult[] groovyResolveResultArray = (GroovyResolveResult[])this.getManager().getResolveCache().resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, false, incomplete);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.multiResolve must not return null");
        }
        return groovyResolveResultArray;
    }

    @Override
    public void processVariants(Consumer<Object> consumer) {
        CompleteReferenceExpression.processVariants(consumer, this);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getSameNameVariants() {
        GroovyResolveResult[] groovyResolveResultArray = RESOLVER.resolve(this, true);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.getSameNameVariants must not return null");
        }
        return groovyResolveResultArray;
    }

    @Override
    public void setQualifierExpression(GrReferenceExpression newQualifier) {
        GrExpression oldQualifier = this.getQualifierExpression();
        ASTNode node = this.getNode();
        PsiElement refNameElement = this.getReferenceNameElement();
        if (newQualifier == null) {
            if (oldQualifier != null && refNameElement != null) {
                node.removeRange(node.getFirstChildNode(), refNameElement.getNode());
            }
        } else if (oldQualifier != null) {
            node.replaceChild(oldQualifier.getNode(), newQualifier.getNode());
        } else if (refNameElement != null) {
            node.addChild(newQualifier.getNode(), refNameElement.getNode());
            node.addLeaf(GroovyTokenTypes.mDOT, (CharSequence)".", refNameElement.getNode());
        }
    }

    @Override
    public GrReferenceExpression bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) {
        if (qualifierClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl.bindToElementViaStaticImport must not be null");
        }
        if (this.getQualifier() != null) {
            throw new IncorrectOperationException("Reference has qualifier");
        }
        if (StringUtil.isEmpty((String)this.getReferenceName())) {
            throw new IncorrectOperationException("Reference has empty name");
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFile) {
            GrImportStatement statement = GroovyPsiElementFactory.getInstance(this.getProject()).createImportStatementFromText("import static " + qualifierClass.getQualifiedName() + "." + this.getReferenceName());
            ((GroovyFile)file).addImport(statement);
        }
        return this;
    }

    static enum Kind {
        TYPE_OR_PROPERTY,
        METHOD_OR_PROPERTY;

    }

    private static class OurResolver
    implements ResolveCache.PolyVariantResolver<GrReferenceExpressionImpl> {
        private OurResolver() {
        }

        public GroovyResolveResult[] resolve(GrReferenceExpressionImpl refExpr, boolean incompleteCode) {
            ResolverProcessor processor;
            String name = refExpr.getReferenceName();
            if (name == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            Kind kind = refExpr.getKind();
            if (incompleteCode) {
                processor = CompletionProcessor.createRefSameNameProcessor(refExpr, name);
                OurResolver.resolveImpl(refExpr, processor);
                GroovyResolveResult[] propertyCandidates = processor.getCandidates();
                if (propertyCandidates.length > 0) {
                    return propertyCandidates;
                }
            }
            if (kind == Kind.METHOD_OR_PROPERTY) {
                PsiType[] argTypes = PsiUtil.getArgumentTypes(refExpr, false);
                PsiType thisType = GrReferenceExpressionImpl.getThisType(refExpr);
                MethodResolverProcessor methodResolver = new MethodResolverProcessor(name, refExpr, false, thisType, argTypes, refExpr.getTypeArguments());
                OurResolver.resolveImpl(refExpr, methodResolver);
                if (methodResolver.hasApplicableCandidates()) {
                    return methodResolver.getCandidates();
                }
                PropertyResolverProcessor propertyResolver = new PropertyResolverProcessor(name, refExpr);
                OurResolver.resolveImpl(refExpr, propertyResolver);
                if (propertyResolver.hasCandidates()) {
                    return propertyResolver.getCandidates();
                }
                String[] names = GroovyPropertyUtils.suggestGettersName(name);
                ArrayList<GroovyResolveResult> list = new ArrayList<GroovyResolveResult>();
                for (String getterName : names) {
                    AccessorResolverProcessor getterResolver = new AccessorResolverProcessor(getterName, refExpr, true);
                    OurResolver.resolveImpl(refExpr, getterResolver);
                    list.addAll(Arrays.asList(getterResolver.getCandidates()));
                }
                if (list.size() > 0) {
                    return list.toArray(new GroovyResolveResult[list.size()]);
                }
                return methodResolver.getCandidates();
            }
            if (kind == Kind.TYPE_OR_PROPERTY) {
                GroovyResolveResult[] fieldCandidates;
                processor = new PropertyResolverProcessor(name, refExpr);
                OurResolver.resolveImpl(refExpr, processor);
                for (GroovyResolveResult candidate : fieldCandidates = processor.getCandidates()) {
                    PsiElement element = candidate.getElement();
                    if (element instanceof PsiField) {
                        PsiClass containingClass = ((PsiField)element).getContainingClass();
                        if (containingClass == null || !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)refExpr, (boolean)true)) continue;
                        return fieldCandidates;
                    }
                    return fieldCandidates;
                }
                boolean isLValue = PsiUtil.isLValue(refExpr);
                String[] names = isLValue ? GroovyPropertyUtils.suggestSettersName(name) : GroovyPropertyUtils.suggestGettersName(name);
                ArrayList<GroovyResolveResult> accessorResults = new ArrayList<GroovyResolveResult>();
                for (String getterName : names) {
                    AccessorResolverProcessor accessorResolver = new AccessorResolverProcessor(getterName, refExpr, !isLValue);
                    OurResolver.resolveImpl(refExpr, accessorResolver);
                    GroovyResolveResult[] candidates = accessorResolver.getCandidates();
                    if (candidates.length == 1 && candidates[0].isStaticsOK()) {
                        return candidates;
                    }
                    accessorResults.addAll(Arrays.asList(candidates));
                }
                if (fieldCandidates.length > 0) {
                    return fieldCandidates;
                }
                if (accessorResults.size() > 0) {
                    return new GroovyResolveResult[]{(GroovyResolveResult)accessorResults.get(0)};
                }
                EnumSet<ClassHint.ResolveKind> kinds = refExpr.getParent() instanceof GrReferenceExpression ? EnumSet.of(ClassHint.ResolveKind.CLASS, ClassHint.ResolveKind.PACKAGE) : EnumSet.of(ClassHint.ResolveKind.CLASS);
                ClassResolverProcessor classProcessor = new ClassResolverProcessor(refExpr.getReferenceName(), refExpr, kinds);
                OurResolver.resolveImpl(refExpr, classProcessor);
                return classProcessor.getCandidates();
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }

        private static void resolveImpl(GrReferenceExpressionImpl refExpr, ResolverProcessor processor) {
            GrExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier == null) {
                ResolveUtil.treeWalkUp(refExpr, processor, true);
                if (!processor.hasCandidates() && (qualifier = PsiImplUtil.getRuntimeQualifier(refExpr)) != null) {
                    OurResolver.processQualifier(refExpr, processor, qualifier);
                }
            } else if (refExpr.getDotTokenType() != GroovyTokenTypes.mSPREAD_DOT) {
                OurResolver.processQualifier(refExpr, processor, qualifier);
            } else {
                OurResolver.processQualifierForSpreadDot(refExpr, processor, qualifier);
            }
        }

        private static void processQualifierForSpreadDot(GrReferenceExpressionImpl refExpr, ResolverProcessor processor, GrExpression qualifier) {
            PsiType qualifierType = qualifier.getType();
            if (qualifierType instanceof PsiClassType) {
                PsiType componentType;
                PsiSubstitutor substitutor;
                PsiClass listClass;
                PsiClassType.ClassResolveResult result = ((PsiClassType)qualifierType).resolveGenerics();
                PsiClass clazz = result.getElement();
                if (clazz != null && (listClass = ResolveUtil.findListClass((PsiManager)refExpr.getManager(), refExpr.getResolveScope())) != null && listClass.getTypeParameters().length == 1 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)listClass, (PsiClass)clazz, (PsiSubstitutor)result.getSubstitutor())) != null && (componentType = substitutor.substitute(listClass.getTypeParameters()[0])) != null) {
                    OurResolver.processClassQualifierType(refExpr, processor, componentType);
                }
            } else if (qualifierType instanceof PsiArrayType) {
                OurResolver.processClassQualifierType(refExpr, processor, ((PsiArrayType)qualifierType).getComponentType());
            }
        }

        private static void processQualifier(GrReferenceExpressionImpl refExpr, ResolverProcessor processor, GrExpression qualifier) {
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                if (qualifier instanceof GrReferenceExpression) {
                    PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                    if (resolved instanceof PsiPackage) {
                        if (!resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)refExpr)) {
                            return;
                        }
                    } else {
                        qualifierType = JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Object", refExpr.getResolveScope());
                        OurResolver.processClassQualifierType(refExpr, processor, qualifierType);
                    }
                }
            } else if (qualifierType instanceof PsiIntersectionType) {
                for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                    OurResolver.processClassQualifierType(refExpr, processor, conjunct);
                }
            } else {
                PsiClass javaLangClass;
                PsiElement resolved;
                OurResolver.processClassQualifierType(refExpr, processor, qualifierType);
                if (qualifier instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass && (javaLangClass = PsiUtil.getJavaLangClass(resolved, refExpr.getResolveScope())) != null) {
                    ResolveState state = ResolveState.initial();
                    PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
                    PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
                    if (substitutor == null) {
                        substitutor = PsiSubstitutor.EMPTY;
                    }
                    if (typeParameters.length == 1) {
                        substitutor = substitutor.put(typeParameters[0], qualifierType);
                        state = state.put(PsiSubstitutor.KEY, (Object)substitutor);
                    }
                    if (!javaLangClass.processDeclarations((PsiScopeProcessor)processor, state, null, (PsiElement)refExpr)) {
                        return;
                    }
                    PsiClassType javaLangClassType = JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory().createType(javaLangClass, substitutor);
                    ResolveUtil.processNonCodeMethods((PsiType)javaLangClassType, processor, refExpr.getProject(), refExpr, false);
                }
            }
        }

        private static void processClassQualifierType(GrReferenceExpressionImpl refExpr, ResolverProcessor processor, PsiType qualifierType) {
            Project project = refExpr.getProject();
            if (qualifierType instanceof PsiClassType) {
                PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)qualifierType).resolveGenerics();
                PsiClass qualifierClass = qualifierResult.getElement();
                if (qualifierClass != null && !qualifierClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor()), null, (PsiElement)refExpr)) {
                    return;
                }
                if (!ResolveUtil.processCategoryMembers(refExpr, processor)) {
                    return;
                }
            } else if (qualifierType instanceof PsiArrayType) {
                GrTypeDefinition arrayClass = GroovyPsiManager.getInstance(project).getArrayClass();
                if (!arrayClass.processDeclarations(processor, ResolveState.initial(), null, refExpr)) {
                    return;
                }
            } else if (qualifierType instanceof PsiIntersectionType) {
                for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                    OurResolver.processClassQualifierType(refExpr, processor, conjunct);
                }
                return;
            }
            ResolveUtil.processNonCodeMethods(qualifierType, processor, project, refExpr, false);
        }
    }

    private static final class OurTypesCalculator
    implements Function<GrReferenceExpressionImpl, PsiType> {
        private OurTypesCalculator() {
        }

        @Nullable
        public PsiType fun(GrReferenceExpressionImpl refExpr) {
            PsiElement resolved;
            PsiType inferred = GroovyPsiManager.getInstance(refExpr.getProject()).getTypeInferenceHelper().getInferredType(refExpr);
            PsiType nominal = refExpr.getNominalTypeImpl();
            if (inferred == null || PsiType.NULL.equals(inferred)) {
                PsiElement resolved2;
                if (nominal == null && (resolved2 = refExpr.resolve()) instanceof GrVariableBase) {
                    return ((GrVariableBase)resolved2).getTypeGroovy();
                }
                return nominal;
            }
            if (nominal == null) {
                return inferred;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)nominal, (PsiType)inferred, (boolean)false) && (resolved = refExpr.resolve()) instanceof GrVariable && ((GrVariable)resolved).getTypeElementGroovy() != null) {
                return nominal;
            }
            return inferred;
        }
    }
}

