/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.types.GrClosureSignatureImpl;

public class GrClosureSignatureUtil {
    private GrClosureSignatureUtil() {
    }

    public static GrClosureSignature createSignature(PsiMethod method) {
        return new GrClosureSignatureImpl(method);
    }

    public static GrClosureSignature createSignature(GrClosableBlock block) {
        return new GrClosureSignatureImpl(block);
    }

    public static GrClosureSignature createSignature(PsiMethod method, PsiSubstitutor substitutor) {
        return new GrClosureSignatureImpl(method, substitutor);
    }

    public static GrClosureSignature createSignature(PsiParameter[] parameters, PsiType returnType) {
        return new GrClosureSignatureImpl(parameters, returnType);
    }

    public static boolean isSignatureApplicable(GrClosureSignature signature, PsiType[] args, GroovyPsiElement context) {
        PsiType arg;
        if (GrClosureSignatureUtil.isApplicable(signature, args, context)) {
            return true;
        }
        return args.length == 1 && (arg = args[0]) instanceof GrTupleType && GrClosureSignatureUtil.isApplicable(signature, args = ((GrTupleType)arg).getComponentTypes(), context);
    }

    private static boolean isApplicable(GrClosureSignature signature, PsiType[] args, GroovyPsiElement context) {
        GrClosureParameter[] params = signature.getParameters();
        if (args.length > params.length && !signature.isVarargs()) {
            return false;
        }
        int optional = GrClosureSignatureUtil.getOptionalParamCount(signature, false);
        int notOptional = params.length - optional;
        if (signature.isVarargs()) {
            --notOptional;
        }
        if (notOptional > args.length) {
            return false;
        }
        if (GrClosureSignatureUtil.isApplicable(params, args, params.length, args.length, context)) {
            return true;
        }
        if (signature.isVarargs()) {
            return new ApplicabilityVerifierForVararg(context, params, args).isApplicable();
        }
        return false;
    }

    private static boolean isApplicable(GrClosureParameter[] params, PsiType[] args, int paramCount, int argCount, GroovyPsiElement context) {
        int optional = GrClosureSignatureUtil.getOptionalParamCount(params, false);
        int notOptional = paramCount - optional;
        int optionalArgs = argCount - notOptional;
        int cur = 0;
        int i = 0;
        while (i < argCount) {
            while (optionalArgs == 0 && cur < paramCount && params[cur].isOptional()) {
                ++cur;
            }
            if (cur == paramCount) {
                return false;
            }
            if (params[cur].isOptional()) {
                --optionalArgs;
            }
            if (!TypesUtil.isAssignableByMethodCallConversion(params[cur].getType(), args[i], context)) {
                return false;
            }
            ++i;
            ++cur;
        }
        return true;
    }

    public static int getOptionalParamCount(GrClosureSignature signature, boolean hasNamedArgs) {
        return GrClosureSignatureUtil.getOptionalParamCount(signature.getParameters(), hasNamedArgs);
    }

    public static int getOptionalParamCount(GrClosureParameter[] parameters, boolean hasNamedArgs) {
        int count = 0;
        int i = 0;
        if (hasNamedArgs) {
            ++i;
        }
        while (i < parameters.length) {
            GrClosureParameter parameter = parameters[i];
            if (parameter.isOptional()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static List<MethodSignature> generateAllSignaturesForMethod(GrMethod method, PsiSubstitutor substitutor) {
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor);
        String name = method.getName();
        GrClosureParameter[] params = signature.getParameters();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        ArrayList<PsiType> newParams = new ArrayList<PsiType>(params.length);
        ArrayList<GrClosureParameter> opts = new ArrayList<GrClosureParameter>(params.length);
        ArrayList<Integer> optInds = new ArrayList<Integer>(params.length);
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isOptional()) {
                opts.add(params[i]);
                optInds.add(i);
                continue;
            }
            newParams.add(params[i].getType());
        }
        ArrayList<MethodSignature> result = new ArrayList<MethodSignature>(opts.size() + 1);
        result.add(GrClosureSignatureUtil.generateSignature(name, newParams, typeParameters, substitutor));
        for (int i = 0; i < opts.size(); ++i) {
            newParams.add((Integer)optInds.get(i), ((GrClosureParameter)opts.get(i)).getType());
            result.add(GrClosureSignatureUtil.generateSignature(name, newParams, typeParameters, substitutor));
        }
        return result;
    }

    public static Map<MethodSignature, List<GrMethod>> findMethodSignatures(GrMethod[] methods) {
        ArrayList<Pair> signatures = new ArrayList<Pair>();
        for (GrMethod method : methods) {
            List<MethodSignature> current = GrClosureSignatureUtil.generateAllSignaturesForMethod(method, PsiSubstitutor.EMPTY);
            for (MethodSignature signature : current) {
                signatures.add(new Pair((Object)signature, (Object)method));
            }
        }
        THashMap map = new THashMap();
        for (Pair pair : signatures) {
            ArrayList<Object> list = (ArrayList<Object>)map.get(pair.first);
            if (list == null) {
                list = new ArrayList<Object>();
                map.put(pair.first, list);
            }
            list.add(pair.second);
        }
        return map;
    }

    private static MethodSignature generateSignature(String name, List<PsiType> paramTypes, PsiTypeParameter[] typeParameters, PsiSubstitutor substitutor) {
        return MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])paramTypes.toArray(new PsiType[paramTypes.size()]), (PsiTypeParameter[])typeParameters, (PsiSubstitutor)substitutor);
    }

    private static class ApplicabilityVerifierForVararg {
        private GroovyPsiElement context;
        GrClosureParameter[] params;
        PsiType[] args;
        PsiType vararg;
        private int paramLength;

        private ApplicabilityVerifierForVararg(GroovyPsiElement context, GrClosureParameter[] params, PsiType[] args) {
            this.context = context;
            this.params = params;
            this.args = args;
            this.paramLength = params.length - 1;
            this.vararg = ((PsiArrayType)params[this.paramLength].getType()).getComponentType();
        }

        public boolean isApplicable() {
            int notOptionals = 0;
            for (int i = 0; i < this.paramLength; ++i) {
                if (this.params[i].isOptional()) continue;
                ++notOptionals;
            }
            return this.isApplicableInternal(0, 0, false, notOptionals);
        }

        private boolean isApplicableInternal(int curParam, int curArg, boolean skipOptionals, int notOptional) {
            if (notOptional > this.args.length - curArg) {
                return false;
            }
            if (notOptional == this.args.length - curArg) {
                skipOptionals = true;
            }
            while (curArg < this.args.length) {
                if (skipOptionals) {
                    while (curParam < this.paramLength && this.params[curParam].isOptional()) {
                        ++curParam;
                    }
                }
                if (curParam == this.paramLength) break;
                if (this.params[curParam].isOptional()) {
                    if (TypesUtil.isAssignable(this.params[curParam].getType(), this.args[curArg], this.context) && this.isApplicableInternal(curParam + 1, curArg + 1, false, notOptional)) {
                        return true;
                    }
                    skipOptionals = true;
                    continue;
                }
                if (!TypesUtil.isAssignableByMethodCallConversion(this.params[curParam].getType(), this.args[curArg], this.context)) {
                    return false;
                }
                --notOptional;
                ++curArg;
                ++curParam;
            }
            while (curArg < this.args.length) {
                if (!TypesUtil.isAssignableByMethodCallConversion(this.vararg, this.args[curArg], this.context)) {
                    return false;
                }
                ++curArg;
            }
            return true;
        }
    }
}

