/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.api.statements;

import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GrNamedArgumentSearchVisitor
extends GroovyRecursiveElementVisitor {
    public static final Set<String>[] EMPTY_SET_ARRAY = new Set[0];
    private static final Set<String> METHOD_NAMES = new HashSet<String>(Arrays.asList("containsKey", "remove", "get"));
    private final Map<String, Set<String>> myMap;

    public GrNamedArgumentSearchVisitor(Map<String, Set<String>> map) {
        this.myMap = map;
    }

    private static void extractArguments(GrArgumentList argumentList, Set<String> set) {
        Object value;
        GrExpression[] expr = argumentList.getExpressionArguments();
        if (expr.length == 1 && expr[0] instanceof GrLiteral && (value = ((GrLiteral)expr[0]).getValue()) instanceof String) {
            set.add((String)value);
        }
    }

    @Override
    public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
        Set<String> set = this.myMap.get(referenceExpression.getName());
        if (set != null && !referenceExpression.isQualified()) {
            PsiElement parent = referenceExpression.getParent();
            if (parent instanceof GrReferenceExpression) {
                GrReferenceExpression parentRef = (GrReferenceExpression)parent;
                PsiElement parentParent = parentRef.getParent();
                if (parentParent instanceof GrMethodCallExpression) {
                    if (METHOD_NAMES.contains(parentRef.getName())) {
                        GrNamedArgumentSearchVisitor.extractArguments(((GrMethodCallExpression)parentParent).getArgumentList(), set);
                    }
                } else {
                    set.add(parentRef.getName());
                }
            } else if (parent instanceof GrIndexProperty) {
                GrIndexProperty indexProperty = (GrIndexProperty)parent;
                GrNamedArgumentSearchVisitor.extractArguments(indexProperty.getArgumentList(), set);
            }
        }
        super.visitReferenceExpression(referenceExpression);
    }
}

