/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.relational;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.ShiftExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class RelationalExpression
implements GroovyElementTypes {
    private static final TokenSet RELATIONS = TokenSet.create((IElementType[])new IElementType[]{mLT, mGT, mLE, mGE, kIN});

    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (ShiftExpression.parse(builder, parser)) {
            if (ParserUtils.getToken(builder, RELATIONS) || RelationalExpression.getCompositeSign(builder)) {
                ParserUtils.getToken(builder, mNLS);
                ShiftExpression.parse(builder, parser);
                marker.done((IElementType)RELATIONAL_EXPRESSION);
            } else if (kINSTANCEOF.equals(builder.getTokenType())) {
                RelationalExpression.advanceLexerAndParseType(builder);
                marker.done((IElementType)INSTANCEOF_EXPRESSION);
            } else if (kAS.equals(builder.getTokenType())) {
                RelationalExpression.advanceLexerAndParseType(builder);
                marker.done((IElementType)SAFE_CAST_EXPRESSION);
            } else {
                marker.drop();
            }
            return true;
        }
        marker.drop();
        return false;
    }

    private static void advanceLexerAndParseType(PsiBuilder builder) {
        builder.advanceLexer();
        PsiBuilder.Marker rb = builder.mark();
        ParserUtils.getToken(builder, mNLS);
        if (!TypeSpec.parse(builder)) {
            rb.rollbackTo();
            builder.error(GroovyBundle.message("type.specification.expected", new Object[0]));
        } else {
            rb.drop();
        }
    }

    private static boolean getCompositeSign(PsiBuilder builder) {
        if (ParserUtils.lookAhead(builder, mGT, mASSIGN)) {
            PsiBuilder.Marker marker = builder.mark();
            for (int i = 0; i < 2; ++i) {
                builder.advanceLexer();
            }
            marker.done((IElementType)COMPOSITE_SHIFT_SIGN);
            return true;
        }
        return false;
    }
}

