/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.ListOrMapConstructorExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ArgumentList
implements GroovyElementTypes {
    public static void parseArgumentList(PsiBuilder builder, IElementType closingBrace, GroovyParser parser) {
        boolean hasFirstArg = ArgumentList.argumentParse(builder, closingBrace, parser);
        if (!hasFirstArg) {
            if (!closingBrace.equals(builder.getTokenType())) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            if (mRCURLY.equals(builder.getTokenType())) {
                return;
            }
            if (!mCOMMA.equals(builder.getTokenType()) && !closingBrace.equals(builder.getTokenType())) {
                builder.advanceLexer();
            }
        }
        ParserUtils.getToken(builder, mNLS);
        while (!builder.eof() && !closingBrace.equals(builder.getTokenType())) {
            if (!hasFirstArg) {
                ParserUtils.getToken(builder, mCOMMA);
            } else {
                ParserUtils.getToken(builder, mCOMMA, "',' or '" + closingBrace + "' expected");
            }
            ParserUtils.getToken(builder, mNLS);
            if (!ArgumentList.argumentParse(builder, closingBrace, parser)) {
                if (!closingBrace.equals(builder.getTokenType())) {
                    builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                }
                if (mRCURLY.equals(builder.getTokenType())) {
                    return;
                }
                if (!mCOMMA.equals(builder.getTokenType()) && !closingBrace.equals(builder.getTokenType())) {
                    builder.advanceLexer();
                }
            }
            ParserUtils.getToken(builder, mNLS);
        }
        ParserUtils.getToken(builder, mNLS);
    }

    private static boolean argumentParse(PsiBuilder builder, IElementType closingBrace, GroovyParser parser) {
        PsiBuilder.Marker argMarker = builder.mark();
        boolean labeled = ArgumentList.argumentLabelStartCheck(builder, parser);
        boolean expanded = ParserUtils.getToken(builder, mSTAR);
        if (labeled) {
            ParserUtils.getToken(builder, mCOLON, GroovyBundle.message("colon.expected", new Object[0]));
        }
        boolean exprParsed = AssignmentExpression.parse(builder, parser);
        if (labeled && !exprParsed) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        while (!builder.eof() && labeled && !mCOMMA.equals(builder.getTokenType()) && !closingBrace.equals(builder.getTokenType())) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            builder.advanceLexer();
            if (!AssignmentExpression.parse(builder, parser)) continue;
        }
        if (labeled || expanded) {
            argMarker.done((IElementType)ARGUMENT);
        } else {
            argMarker.drop();
        }
        return labeled || exprParsed;
    }

    public static boolean argumentLabelStartCheck(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (ParserUtils.lookAhead(builder, mSTAR, mCOLON)) {
            builder.advanceLexer();
            marker.done((IElementType)ARGUMENT_LABEL);
            return true;
        }
        if (ParserUtils.lookAhead(builder, mIDENT, mCOLON) || TokenSets.KEYWORD_REFERENCE_NAMES.contains(builder.getTokenType()) || TokenSets.NUMBERS.contains(builder.getTokenType()) || mSTRING_LITERAL.equals(builder.getTokenType()) || mGSTRING_LITERAL.equals(builder.getTokenType())) {
            builder.advanceLexer();
            if (mCOLON.equals(builder.getTokenType())) {
                marker.done((IElementType)ARGUMENT_LABEL);
                return true;
            }
            marker.rollbackTo();
            return false;
        }
        if (mGSTRING_BEGIN.equals(builder.getTokenType()) || mLPAREN.equals(builder.getTokenType()) || mLCURLY.equals(builder.getTokenType())) {
            PrimaryExpression.parse(builder, parser);
            if (mCOLON.equals(builder.getTokenType())) {
                marker.done((IElementType)ARGUMENT_LABEL);
                return true;
            }
            marker.rollbackTo();
            return false;
        }
        if (mLBRACK.equals(builder.getTokenType())) {
            ListOrMapConstructorExpression.parse(builder, parser);
            if (mCOLON.equals(builder.getTokenType())) {
                marker.done((IElementType)ARGUMENT_LABEL);
                return true;
            }
            marker.rollbackTo();
            return false;
        }
        marker.drop();
        return false;
    }
}

