/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.ThrowClause;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.AnnotationArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.TupleParse;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class VariableDefinitions
implements GroovyElementTypes {
    public static IElementType parse(PsiBuilder builder, boolean isInClass, boolean hasModifiers, GroovyParser parser) {
        return VariableDefinitions.parseDefinitions(builder, isInClass, false, false, false, hasModifiers, true, parser);
    }

    public static IElementType parse(PsiBuilder builder, boolean isInClass, boolean hasModifiers, boolean canBeTuple, GroovyParser parser) {
        return VariableDefinitions.parseDefinitions(builder, isInClass, false, false, false, hasModifiers, canBeTuple, parser);
    }

    public static IElementType parseDefinitions(PsiBuilder builder, boolean isInClass, boolean isEnumConstantMember, boolean isAnnotationMember, boolean mustBeMethod, boolean hasModifiers, boolean canBeTuple, GroovyParser parser) {
        boolean isStringName;
        boolean isLParen = builder.getTokenType() == mLPAREN;
        boolean bl = isStringName = builder.getTokenType() == mSTRING_LITERAL || builder.getTokenType() == mGSTRING_LITERAL;
        if (builder.getTokenType() != mIDENT && !isStringName && !isLParen) {
            builder.error(GroovyBundle.message("indentifier.or.string.or.left.parenth.literal.expected", new Object[0]));
            return WRONGWAY;
        }
        if (isLParen && !canBeTuple) {
            builder.error(GroovyBundle.message("indentifier.or.string.or.left.parenth.literal.expected", new Object[0]));
            return WRONGWAY;
        }
        if (isLParen && mustBeMethod) {
            return WRONGWAY;
        }
        if (isAnnotationMember && isStringName) {
            builder.error(GroovyBundle.message("string.name.unexpected", new Object[0]));
        }
        if (!isLParen) {
            PsiBuilder.Marker varMarker = builder.mark();
            builder.advanceLexer();
            if (mLPAREN != builder.getTokenType()) {
                if (mustBeMethod) {
                    varMarker.drop();
                    return WRONGWAY;
                }
                varMarker.rollbackTo();
            } else {
                varMarker.drop();
                if (!hasModifiers) {
                    builder.error(GroovyBundle.message("method.definition.without.modifier", new Object[0]));
                    return WRONGWAY;
                }
                builder.advanceLexer();
                ParameterList.parse(builder, mRPAREN, parser);
                if (isEnumConstantMember && !isStringName) {
                    builder.error(GroovyBundle.message("string.name.unexpected", new Object[0]));
                }
                ParserUtils.getToken(builder, mNLS);
                if (!ParserUtils.getToken(builder, mRPAREN)) {
                    builder.error(GroovyBundle.message("rparen.expected", new Object[0]));
                    ThrowClause.parse(builder);
                    return METHOD_DEFINITION;
                }
                if (builder.getTokenType() == kDEFAULT) {
                    PsiBuilder.Marker defaultValueMarker = builder.mark();
                    ParserUtils.getToken(builder, kDEFAULT);
                    ParserUtils.getToken(builder, mNLS);
                    if (!AnnotationArguments.parseAnnotationMemberValueInitializer(builder, parser)) {
                        builder.error(GroovyBundle.message("annotation.initializer.expected", new Object[0]));
                    }
                    defaultValueMarker.done((IElementType)DEFAULT_ANNOTATION_VALUE);
                    return ANNOTATION_METHOD;
                }
                if (ParserUtils.lookAhead(builder, mNLS, kTHROWS) || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
                    ParserUtils.getToken(builder, mNLS);
                }
                ThrowClause.parse(builder);
                if (builder.getTokenType() == mLCURLY || ParserUtils.lookAhead(builder, mNLS, mLCURLY)) {
                    ParserUtils.getToken(builder, mNLS);
                    OpenOrClosableBlock.parseOpenBlock(builder, parser);
                }
                return METHOD_DEFINITION;
            }
        }
        PsiBuilder.Marker varAssMarker = builder.mark();
        IElementType declarator = VariableDefinitions.parseDeclarator(builder, isLParen, hasModifiers);
        if (declarator != WRONGWAY) {
            boolean wasAssingment = VariableDefinitions.parseAssignment(builder, parser);
            if (declarator == TUPLE_DECLARATION || declarator == TUPLE_ERROR) {
                varAssMarker.drop();
                if (!wasAssingment && !hasModifiers) {
                    builder.error(GroovyBundle.message("assignment.expected", new Object[0]));
                    return WRONGWAY;
                }
            } else if (isInClass) {
                varAssMarker.done((IElementType)FIELD);
            } else {
                varAssMarker.done((IElementType)VARIABLE);
            }
            while (ParserUtils.getToken(builder, mCOMMA)) {
                ParserUtils.getToken(builder, mNLS);
                if (!((Object)((Object)WRONGWAY)).equals(VariableDefinitions.parseVariableOrField(builder, isInClass, parser)) || declarator != mIDENT) continue;
                return VARIABLE_DEFINITION_ERROR;
            }
            if (isInClass && declarator == TUPLE_DECLARATION) {
                builder.error(GroovyBundle.message("tuple.cant.be.placed.in.class", new Object[0]));
            }
            return declarator == TUPLE_DECLARATION ? MULTIPLE_VARIABLE_DEFINITION : VARIABLE_DEFINITION;
        }
        varAssMarker.drop();
        builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
        return WRONGWAY;
    }

    private static IElementType parseVariableOrField(PsiBuilder builder, boolean isInClass, GroovyParser parser) {
        PsiBuilder.Marker varAssMarker = builder.mark();
        if (ParserUtils.getToken(builder, mIDENT)) {
            VariableDefinitions.parseAssignment(builder, parser);
            if (isInClass) {
                varAssMarker.done((IElementType)FIELD);
                return FIELD;
            }
            varAssMarker.done((IElementType)VARIABLE);
            return VARIABLE;
        }
        varAssMarker.drop();
        builder.error("Identifier expected");
        return WRONGWAY;
    }

    private static IElementType parseDeclarator(PsiBuilder builder, boolean isTuple, boolean hasModifiers) {
        if (!isTuple) {
            if (builder.getTokenType() == mIDENT) {
                ParserUtils.getToken(builder, mIDENT);
                return mIDENT;
            }
        } else if (builder.getTokenType() == mLPAREN && isTuple && TupleParse.parseTuple(builder, hasModifiers, TUPLE_DECLARATION, VARIABLE)) {
            return TUPLE_DECLARATION;
        }
        return WRONGWAY;
    }

    private static boolean parseAssignment(PsiBuilder builder, GroovyParser parser) {
        if (ParserUtils.getToken(builder, mASSIGN)) {
            PsiBuilder.Marker marker = builder.mark();
            ParserUtils.getToken(builder, mNLS);
            if (!AssignmentExpression.parse(builder, parser)) {
                marker.rollbackTo();
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                return false;
            }
            marker.drop();
            return true;
        }
        return false;
    }
}

