/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TupleParse {
    public static boolean parseTuple(PsiBuilder builder, boolean hasModifiers, IElementType tupleType, IElementType componentType) {
        if (builder.getTokenType() != GroovyTokenTypes.mLPAREN) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        while (true) {
            if (builder.getTokenType() == GroovyTokenTypes.mCOMMA) {
                builder.advanceLexer();
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                continue;
            }
            if (hasModifiers && TokenSets.BUILT_IN_TYPE.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            PsiBuilder.Marker varMarker = builder.mark();
            if (!ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT)) {
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                varMarker.drop();
            } else {
                varMarker.done(componentType);
            }
            if (!ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) break;
        }
        if (builder.getTokenType() == GroovyTokenTypes.mRPAREN) {
            builder.advanceLexer();
            marker.done(tupleType);
            return true;
        }
        marker.rollbackTo();
        return false;
    }
}

