/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.template.expressions;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeEquals;

public class ChooseTypeExpression
extends Expression {
    protected SmartTypePointer myTypePointer;
    private final LookupElement[] myItems;
    private final PsiManager myManager;

    public ChooseTypeExpression(TypeConstraint[] constraints, PsiManager manager) {
        this.myManager = manager;
        this.myTypePointer = SmartTypePointerManager.getInstance((Project)manager.getProject()).createSmartTypePointer(this.chooseType(constraints));
        this.myItems = this.createItems(constraints);
    }

    private LookupElement[] createItems(TypeConstraint[] constraints) {
        LinkedHashSet<LookupElement> result = new LinkedHashSet<LookupElement>();
        for (TypeConstraint constraint : constraints) {
            if (constraint instanceof TypeEquals) {
                result.add((LookupElement)PsiTypeLookupItem.createLookupItem((PsiType)constraint.getType(), null));
                continue;
            }
            if (constraint instanceof SubtypeConstraint) {
                result.add((LookupElement)PsiTypeLookupItem.createLookupItem((PsiType)constraint.getDefaultType(), null));
                continue;
            }
            if (!(constraint instanceof SupertypeConstraint)) continue;
            ChooseTypeExpression.processSupertypes(constraint.getType(), result);
        }
        result.add((LookupElement)LookupElementBuilder.create((String)"def").setBold());
        return result.toArray(new LookupElement[result.size()]);
    }

    private static void processSupertypes(PsiType type, Set<LookupElement> result) {
        PsiType[] superTypes;
        String text = type.getCanonicalText();
        String unboxed = PsiTypesUtil.unboxIfPossible((String)text);
        if (unboxed != null && !unboxed.equals(text)) {
            result.add((LookupElement)LookupElementBuilder.create((String)unboxed).setBold());
        } else {
            result.add((LookupElement)PsiTypeLookupItem.createLookupItem((PsiType)type, null));
        }
        for (PsiType superType : superTypes = type.getSuperTypes()) {
            ChooseTypeExpression.processSupertypes(superType, result);
        }
    }

    private PsiType chooseType(TypeConstraint[] constraints) {
        if (constraints.length > 0) {
            return constraints[0].getDefaultType();
        }
        return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Object", GlobalSearchScope.allScope((Project)this.myManager.getProject()));
    }

    public Result calculateResult(ExpressionContext context) {
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        PsiType type = this.myTypePointer.getType();
        if (type != null) {
            return new PsiTypeResult(type, context.getProject());
        }
        return null;
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        return this.myItems;
    }
}

