/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.DeclarationMover;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.Mover;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.StatementMover;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyMoveStatementHandler
extends EditorWriteActionHandler {
    protected EditorActionHandler myOriginalHandler;
    private final boolean isDown;
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.GroovyMoveStatementHandler");

    public GroovyMoveStatementHandler(EditorActionHandler originalHandler, boolean down) {
        this.myOriginalHandler = originalHandler;
        this.isDown = down;
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return editor.getProject() != null && HandlerUtils.isEnabled(editor, dataContext, this.myOriginalHandler);
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        if (this.isEnabled(editor, dataContext) && this.executeWriteActionInner(editor, dataContext)) {
            return;
        }
        if (this.myOriginalHandler.isEnabled(editor, dataContext)) {
            this.myOriginalHandler.execute(editor, dataContext);
        }
    }

    private boolean executeWriteActionInner(Editor editor, DataContext dataContext) {
        Document document;
        Project project = editor.getProject();
        if (project == null || !HandlerUtils.canBeInvoked(editor, project) || PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project) != GroovyFileType.GROOVY_FILE_TYPE.getLanguage()) {
            return false;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = documentManager.getPsiFile(document = editor.getDocument());
        if (file == null || !(file instanceof GroovyFile)) {
            return false;
        }
        documentManager.commitDocument(document);
        Mover mover = this.getSuitableMover(editor, (GroovyFile)file);
        if (mover == null) {
            return false;
        }
        mover.move(editor, file);
        return true;
    }

    private Mover getSuitableMover(Editor editor, GroovyFile file) {
        Mover[] movers;
        for (Mover mover : movers = new Mover[]{new StatementMover(this.isDown), new DeclarationMover(this.isDown)}) {
            boolean available = mover.checkAvailable(editor, file);
            if (!available) continue;
            return mover;
        }
        return null;
    }
}

