/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.LineMover;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.LineRange;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class DeclarationMover
extends LineMover {
    public DeclarationMover(boolean isDown) {
        super(isDown);
    }

    @Override
    protected boolean checkAvailable(Editor editor, PsiFile file) {
        LineRange range;
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        boolean available = super.checkAvailable(editor, file);
        if (!available) {
            return false;
        }
        LineRange oldRange = this.toMove;
        Pair<PsiElement, PsiElement> psiRange = DeclarationMover.getElementRange(editor, file, oldRange);
        if (psiRange == null) {
            return false;
        }
        PsiElement first = (PsiElement)psiRange.getFirst();
        first = PsiUtil.isNewLine(first) ? first.getNextSibling() : first;
        PsiElement firstMember = DeclarationMover.findMemberParent(first);
        if (firstMember == null) {
            return false;
        }
        PsiElement second = (PsiElement)psiRange.getSecond();
        second = PsiUtil.isNewLine(second) ? second.getPrevSibling() : second;
        PsiElement lastMember = DeclarationMover.findMemberParent(second);
        if (lastMember == null) {
            return false;
        }
        if (firstMember == lastMember) {
            range = DeclarationMover.memberRange(firstMember, editor, oldRange);
            if (range == null) {
                return false;
            }
            range.firstElement = range.lastElement = firstMember;
        } else {
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)firstMember, (PsiElement)lastMember);
            if (parent == null) {
                return false;
            }
            Pair<PsiElement, PsiElement> combinedRange = DeclarationMover.getElementRange(parent, firstMember, lastMember);
            if (combinedRange == null) {
                return false;
            }
            LineRange lineRange1 = DeclarationMover.memberRange((PsiElement)combinedRange.getFirst(), editor, oldRange);
            if (lineRange1 == null) {
                return false;
            }
            LineRange lineRange2 = DeclarationMover.memberRange((PsiElement)combinedRange.getSecond(), editor, oldRange);
            if (lineRange2 == null) {
                return false;
            }
            range = new LineRange(lineRange1.startLine, lineRange2.endLine);
            range.firstElement = (PsiElement)combinedRange.getFirst();
            range.lastElement = (PsiElement)combinedRange.getSecond();
        }
        Document document = editor.getDocument();
        PsiElement sibling = this.isDown ? range.lastElement.getNextSibling() : range.firstElement.getPrevSibling();
        try {
            if (sibling == null) {
                throw new IllegalMoveException();
            }
            sibling = DeclarationMover.firstNonWhiteElement(sibling, this.isDown, true);
            boolean areWeMovingClass = range.firstElement instanceof GrTypeDefinition;
            this.toMove = range;
            LineRange intraClassRange = this.moveInsideOutsideClassPosition(editor, sibling, this.isDown, areWeMovingClass);
            this.toMove2 = intraClassRange == null ? new LineRange(sibling, sibling, document) : intraClassRange;
        }
        catch (IllegalMoveException e) {
            this.toMove2 = null;
        }
        return true;
    }

    @Nullable
    private static PsiElement findMemberParent(PsiElement first) {
        GrMember[] members;
        if (first instanceof GrMembersDeclaration && (members = ((GrMembersDeclaration)first).getMembers()).length > 0) {
            return first;
        }
        GrDocComment comment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)first, GrDocComment.class, (boolean)false);
        GrDocCommentOwner member = comment != null ? comment.getOwner() : PsiTreeUtil.getParentOfType((PsiElement)first, GrMember.class, (boolean)false);
        if (member == null) {
            member = PsiTreeUtil.getParentOfType((PsiElement)first, GrTypeDefinition.class, (boolean)false);
        }
        return member;
    }

    @Nullable
    private static LineRange memberRange(@NotNull PsiElement member, Editor editor, LineRange lineRange) {
        GrDocComment comment;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/actions/moveUpDown/DeclarationMover.memberRange must not be null");
        }
        TextRange textRange = member.getTextRange();
        if (editor.getDocument().getTextLength() < textRange.getEndOffset()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
        int endLine = editor.offsetToLogicalPosition((int)textRange.getEndOffset()).line + 1;
        if (!DeclarationMover.isInsideDeclaration(member, startLine, endLine, lineRange, editor)) {
            return null;
        }
        if (member instanceof GrDocCommentOwner && (comment = ((GrDocCommentOwner)member).getDocComment()) != null) {
            int docStart = editor.offsetToLogicalPosition((int)comment.getTextRange().getStartOffset()).line;
            return new LineRange(docStart, endLine);
        }
        return new LineRange(startLine, endLine);
    }

    private static boolean isInsideDeclaration(@NotNull PsiElement member, int startLine, int endLine, LineRange lineRange, Editor editor) {
        PsiElement nameIdentifier;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/actions/moveUpDown/DeclarationMover.isInsideDeclaration must not be null");
        }
        if (startLine == lineRange.startLine || startLine == lineRange.endLine || endLine == lineRange.startLine || endLine == lineRange.endLine) {
            return true;
        }
        ArrayList<PsiElement> memberSuspects = new ArrayList<PsiElement>();
        if (member instanceof GrMember) {
            ContainerUtil.addIfNotNull((Object)((GrMember)member).getModifierList(), memberSuspects);
        }
        if (member instanceof GrDocCommentOwner) {
            ContainerUtil.addIfNotNull((Object)((GrDocCommentOwner)member).getDocComment(), memberSuspects);
        }
        if (member instanceof GrMethod) {
            GrMethod method = (GrMethod)member;
            nameIdentifier = method.getNameIdentifierGroovy();
            memberSuspects.add(nameIdentifier);
            GrTypeElement returnTypeElement = method.getReturnTypeElementGroovy();
            if (returnTypeElement != null) {
                memberSuspects.add(returnTypeElement);
            }
        }
        if (member instanceof GrField) {
            GrField field = (GrField)member;
            nameIdentifier = field.getNameIdentifierGroovy();
            memberSuspects.add(nameIdentifier);
            GrTypeElement typeElement = field.getTypeElementGroovy();
            if (typeElement != null) {
                memberSuspects.add(typeElement);
            }
        }
        TextRange lineTextRange = new TextRange(editor.getDocument().getLineStartOffset(lineRange.startLine), editor.getDocument().getLineEndOffset(lineRange.endLine));
        for (PsiElement suspect : memberSuspects) {
            TextRange textRange = suspect.getTextRange();
            if (textRange == null || !lineTextRange.intersects(textRange)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private LineRange moveInsideOutsideClassPosition(Editor editor, PsiElement sibling, boolean isDown, boolean areWeMovingClass) throws IllegalMoveException {
        if (sibling == null) {
            throw new IllegalMoveException();
        }
        if (sibling.getNode() != null && sibling.getNode().getElementType() == (isDown ? GroovyTokenTypes.mRCURLY : GroovyTokenTypes.mLCURLY) && sibling.getParent() instanceof GrTypeDefinitionBody) {
            PsiElement start;
            GrTypeDefinition aClass = (GrTypeDefinition)sibling.getParent().getParent();
            PsiElement parent = aClass.getParent();
            if (!areWeMovingClass && !(parent instanceof GrTypeDefinitionBody)) {
                throw new IllegalMoveException();
            }
            Object object = start = isDown ? sibling : aClass.getModifierList();
            if (start == null) {
                throw new IllegalMoveException();
            }
            return new LineRange(start, sibling, editor.getDocument());
        }
        return null;
    }

    private static class IllegalMoveException
    extends Exception {
        private IllegalMoveException() {
        }
    }
}

