/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

class ExpandBooleanPredicate
implements PsiElementPredicate {
    private static final Logger LOGGER = Logger.getInstance((String)"ExpandBooleanPredicate");

    ExpandBooleanPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof GrStatement)) {
            return false;
        }
        GrStatement statement = (GrStatement)element;
        return ExpandBooleanPredicate.isBooleanReturn(statement) || ExpandBooleanPredicate.isBooleanAssignment(statement);
    }

    public static boolean isBooleanReturn(GrStatement statement) {
        if (!(statement instanceof GrReturnStatement)) {
            return false;
        }
        GrReturnStatement returnStatement = (GrReturnStatement)statement;
        GrExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return false;
        }
        if (returnValue instanceof GrLiteral) {
            return false;
        }
        PsiType returnType = returnValue.getType();
        if (returnType == null) {
            return false;
        }
        return returnType.equals(PsiType.BOOLEAN) || returnType.equalsToText("java.lang.Boolean");
    }

    public static boolean isBooleanAssignment(GrStatement expression) {
        if (!(expression instanceof GrAssignmentExpression)) {
            return false;
        }
        GrAssignmentExpression assignment = (GrAssignmentExpression)expression;
        GrExpression rhs = assignment.getRValue();
        if (rhs == null) {
            return false;
        }
        if (rhs instanceof GrLiteral) {
            return false;
        }
        PsiType assignmentType = rhs.getType();
        if (assignmentType == null) {
            return false;
        }
        return assignmentType.equals(PsiType.BOOLEAN) || assignmentType.equalsToText("java.lang.Boolean");
    }
}

