/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ExpandBooleanPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class ExpandBooleanIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpandBooleanPredicate expandBooleanPredicate = new ExpandBooleanPredicate();
        if (expandBooleanPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/control/ExpandBooleanIntention.getElementPredicate must not return null");
        }
        return expandBooleanPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/control/ExpandBooleanIntention.processIntention must not be null");
        }
        GrStatement containingStatement = (GrStatement)element;
        if (ExpandBooleanPredicate.isBooleanAssignment(containingStatement)) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)containingStatement;
            GrExpression rhs = assignmentExpression.getRValue();
            assert (rhs != null);
            String rhsText = rhs.getText();
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            String statement = "if(" + rhsText + "){" + lhsText + " = true;}else{" + lhsText + " = false;}";
            IntentionUtils.replaceStatement(statement, containingStatement);
        } else if (ExpandBooleanPredicate.isBooleanReturn(containingStatement)) {
            GrReturnStatement returnStatement = (GrReturnStatement)containingStatement;
            GrExpression returnValue = returnStatement.getReturnValue();
            String valueText = returnValue.getText();
            String statement = "if(" + valueText + "){return true;}else{return false;}";
            IntentionUtils.replaceStatement(statement, containingStatement);
        }
    }
}

