/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ConditionalToElvisPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class ConditionalToElvisIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/control/ConditionalToElvisIntention.processIntention must not be null");
        }
        GrConditionalExpression expr = (GrConditionalExpression)element;
        GrExpression thenExpression = expr.getThenBranch();
        GrExpression elseExpression = expr.getElseBranch();
        assert (elseExpression != null);
        assert (thenExpression != null);
        String newExpression = thenExpression.getText() + " ?: " + elseExpression.getText();
        IntentionUtils.replaceExpression(newExpression, expr);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConditionalToElvisPredicate conditionalToElvisPredicate = new ConditionalToElvisPredicate();
        if (conditionalToElvisPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/control/ConditionalToElvisIntention.getElementPredicate must not return null");
        }
        return conditionalToElvisPredicate;
    }
}

