/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.base;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.lang.editor.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.lang.editor.template.expressions.ParameterNameExpression;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class IntentionUtils {
    public static void replaceExpression(@NotNull String newExpression, @NotNull GrExpression expression) throws IncorrectOperationException {
        if (newExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/base/IntentionUtils.replaceExpression must not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/base/IntentionUtils.replaceExpression must not be null");
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression newCall = factory.createExpressionFromText(newExpression);
        GrExpression insertedElement = expression.replaceWithExpression(newCall, true);
    }

    public static GrStatement replaceStatement(@NonNls @NotNull String newStatement, @NonNls @NotNull GrStatement statement) throws IncorrectOperationException {
        if (newStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/base/IntentionUtils.replaceStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/base/IntentionUtils.replaceStatement must not be null");
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        GrStatement newCall = (GrStatement)factory.createTopElementFromText(newStatement);
        return statement.replaceWithStatement(newCall);
    }

    public static void createTemplateForMethod(PsiType[] argTypes, ChooseTypeExpression[] paramTypesExpressions, GrMethod method, GrMemberOwner owner, TypeConstraint[] constraints, boolean isConstructor) {
        Project project = owner.getProject();
        GrTypeElement typeElement = method.getReturnTypeElementGroovy();
        ChooseTypeExpression expr = new ChooseTypeExpression(constraints, PsiManager.getInstance((Project)project));
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        if (!isConstructor) {
            assert (typeElement != null);
            builder.replaceElement((PsiElement)typeElement, (Expression)expr);
        }
        GrParameter[] parameters = method.getParameterList().getParameters();
        assert (parameters.length == argTypes.length);
        for (int i = 0; i < parameters.length; ++i) {
            GrParameter parameter = parameters[i];
            GrTypeElement parameterTypeElement = parameter.getTypeElementGroovy();
            builder.replaceElement((PsiElement)parameterTypeElement, (Expression)paramTypesExpressions[i]);
            builder.replaceElement(parameter.getNameIdentifierGroovy(), (Expression)new ParameterNameExpression());
        }
        GrOpenBlock body = method.getBlock();
        assert (body != null);
        PsiElement lbrace = body.getLBrace();
        assert (lbrace != null);
        builder.setEndVariableAfter(lbrace);
        method = (GrMethod)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        Template template = builder.buildTemplate();
        Editor newEditor = QuickfixUtil.positionCursor(project, owner.getContainingFile(), method);
        TextRange range = method.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, template);
    }
}

